/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.HyperEdge;
import org.apache.calcite.rel.rules.HyperGraph;
import org.apache.calcite.rel.rules.LongBitmap;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DpHyp {
    private final HyperGraph hyperGraph;
    private final HashMap<Long, RelNode> dpTable;
    private final RelBuilder builder;
    private final RelMetadataQuery mq;

    public DpHyp(HyperGraph hyperGraph, RelBuilder builder, RelMetadataQuery relMetadataQuery) {
        this.hyperGraph = hyperGraph.copy(hyperGraph.getTraitSet(), (List)hyperGraph.getInputs());
        this.dpTable = new HashMap();
        this.builder = builder;
        this.mq = relMetadataQuery;
        this.hyperGraph.convertHyperEdgeCond(builder);
    }

    public void startEnumerateJoin() {
        int i;
        int size = this.hyperGraph.getInputs().size();
        for (i = 0; i < size; ++i) {
            long singleNode = LongBitmap.newBitmap(i);
            this.dpTable.put(singleNode, this.hyperGraph.getInput(i));
            this.hyperGraph.initEdgeBitMap(singleNode);
        }
        for (i = size - 2; i >= 0; --i) {
            long csg = LongBitmap.newBitmap(i);
            long forbidden = csg - 1L;
            this.emitCsg(csg);
            this.enumerateCsgRec(csg, forbidden);
        }
    }

    private void emitCsg(long csg) {
        long forbidden = csg | LongBitmap.getBvBitmap(csg);
        long neighbors = this.hyperGraph.getNeighborBitmap(csg, forbidden);
        LongBitmap.ReverseIterator reverseIterator = new LongBitmap.ReverseIterator(neighbors);
        for (long cmp : reverseIterator) {
            List<HyperEdge> edges = this.hyperGraph.connectCsgCmp(csg, cmp);
            if (!edges.isEmpty()) {
                this.emitCsgCmp(csg, cmp, edges);
            }
            long newForbidden = (cmp | LongBitmap.getBvBitmap(cmp)) & neighbors;
            this.enumerateCmpRec(csg, cmp, newForbidden |= forbidden);
        }
    }

    private void enumerateCsgRec(long csg, long forbidden) {
        long neighbors = this.hyperGraph.getNeighborBitmap(csg, forbidden);
        LongBitmap.SubsetIterator subsetIterator = new LongBitmap.SubsetIterator(neighbors);
        for (long subNeighbor : subsetIterator) {
            this.hyperGraph.updateEdgesForUnion(csg, subNeighbor);
            long newCsg = csg | subNeighbor;
            if (!this.dpTable.containsKey(newCsg)) continue;
            this.emitCsg(newCsg);
        }
        long newForbidden = forbidden | neighbors;
        subsetIterator.reset();
        for (long subNeighbor : subsetIterator) {
            long newCsg = csg | subNeighbor;
            this.enumerateCsgRec(newCsg, newForbidden);
        }
    }

    private void enumerateCmpRec(long csg, long cmp, long forbidden) {
        long neighbors = this.hyperGraph.getNeighborBitmap(cmp, forbidden);
        LongBitmap.SubsetIterator subsetIterator = new LongBitmap.SubsetIterator(neighbors);
        for (long subNeighbor : subsetIterator) {
            List<HyperEdge> edges;
            long newCmp = cmp | subNeighbor;
            this.hyperGraph.updateEdgesForUnion(cmp, subNeighbor);
            if (!this.dpTable.containsKey(newCmp) || (edges = this.hyperGraph.connectCsgCmp(csg, newCmp)).isEmpty()) continue;
            this.emitCsgCmp(csg, newCmp, edges);
        }
        long newForbidden = forbidden | neighbors;
        subsetIterator.reset();
        for (long subNeighbor : subsetIterator) {
            long newCmp = cmp | subNeighbor;
            this.enumerateCmpRec(csg, newCmp, newForbidden);
        }
    }

    private void emitCsgCmp(long csg, long cmp, List<HyperEdge> edges) {
        RelNode child1 = this.dpTable.get(csg);
        RelNode child2 = this.dpTable.get(cmp);
        if (child1 == null || child2 == null) {
            throw new IllegalArgumentException("csg and cmp were not enumerated in the previous dp process");
        }
        JoinRelType joinType = this.hyperGraph.extractJoinType(edges);
        if (joinType == null) {
            return;
        }
        RexNode joinCond1 = this.hyperGraph.extractJoinCond(child1, child2, edges);
        RelNode newPlan1 = this.builder.push(child1).push(child2).join(joinType, joinCond1).build();
        RexNode joinCond2 = this.hyperGraph.extractJoinCond(child2, child1, edges);
        RelNode newPlan2 = this.builder.push(child2).push(child1).join(joinType, joinCond2).build();
        RelNode winPlan = this.chooseBetterPlan(newPlan1, newPlan2);
        RelNode oriPlan = this.dpTable.get(csg | cmp);
        if (oriPlan != null) {
            winPlan = this.chooseBetterPlan(winPlan, oriPlan);
        }
        this.dpTable.put(csg | cmp, winPlan);
    }

    public @Nullable RelNode getBestPlan() {
        int size = this.hyperGraph.getInputs().size();
        long wholeGraph = LongBitmap.newBitmapBetween(0, size);
        return this.dpTable.get(wholeGraph);
    }

    private RelNode chooseBetterPlan(RelNode plan1, RelNode plan2) {
        RelOptCost cost1 = this.mq.getCumulativeCost(plan1);
        RelOptCost cost2 = this.mq.getCumulativeCost(plan2);
        if (cost1 != null && cost2 != null) {
            return cost1.isLt(cost2) ? plan1 : plan2;
        }
        if (cost1 != null) {
            return plan1;
        }
        return plan2;
    }
}

