/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcBaseSchema;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcTable;
import org.apache.calcite.adapter.jdbc.JdbcUtils;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.lookup.IgnoreCaseLookup;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.schema.lookup.Lookup;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.LazyReference;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSchema
extends JdbcBaseSchema
implements Schema,
Wrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSchema.class);
    final DataSource dataSource;
    final @Nullable String catalog;
    final @Nullable String schema;
    public final SqlDialect dialect;
    final JdbcConvention convention;
    private final LazyReference<Lookup<Table>> tables = new LazyReference();
    private final Lookup<JdbcSchema> subSchemas = Lookup.empty();
    public static final ThreadLocal<@Nullable Foo> THREAD_METADATA = new ThreadLocal();
    private static final Ordering<Iterable<Integer>> VERSION_ORDERING = Ordering.natural().lexicographical();

    public JdbcSchema(DataSource dataSource, SqlDialect dialect, JdbcConvention convention, @Nullable String catalog, @Nullable String schema) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
        this.dialect = Objects.requireNonNull(dialect, "dialect");
        this.convention = convention;
        this.catalog = catalog;
        this.schema = schema;
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, DataSource dataSource, @Nullable String catalog, @Nullable String schema) {
        return JdbcSchema.create(parentSchema, name, dataSource, SqlDialectFactoryImpl.INSTANCE, catalog, schema);
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, DataSource dataSource, SqlDialectFactory dialectFactory, @Nullable String catalog, @Nullable String schema) {
        Expression expression = Schemas.subSchemaExpression(parentSchema, name, JdbcSchema.class);
        SqlDialect dialect = JdbcSchema.createDialect(dialectFactory, dataSource);
        JdbcConvention convention = JdbcConvention.of(dialect, expression, name);
        return new JdbcSchema(dataSource, dialect, convention, catalog, schema);
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        DataSource dataSource;
        try {
            String dataSourceName = (String)operand.get("dataSource");
            if (dataSourceName != null) {
                dataSource = (DataSource)AvaticaUtils.instantiatePlugin(DataSource.class, (String)dataSourceName);
            } else {
                String jdbcUrl = (String)Objects.requireNonNull(operand.get("jdbcUrl"), "jdbcUrl");
                String jdbcDriver = (String)operand.get("jdbcDriver");
                String jdbcUser = (String)operand.get("jdbcUser");
                String jdbcPassword = (String)operand.get("jdbcPassword");
                dataSource = JdbcSchema.dataSource(jdbcUrl, jdbcDriver, jdbcUser, jdbcPassword);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading dataSource", e);
        }
        String jdbcCatalog = (String)operand.get("jdbcCatalog");
        String jdbcSchema = (String)operand.get("jdbcSchema");
        String sqlDialectFactory = (String)operand.get("sqlDialectFactory");
        if (sqlDialectFactory == null || sqlDialectFactory.isEmpty()) {
            return JdbcSchema.create(parentSchema, name, dataSource, jdbcCatalog, jdbcSchema);
        }
        SqlDialectFactory factory = (SqlDialectFactory)AvaticaUtils.instantiatePlugin(SqlDialectFactory.class, (String)sqlDialectFactory);
        return JdbcSchema.create(parentSchema, name, dataSource, factory, jdbcCatalog, jdbcSchema);
    }

    @Deprecated
    public static SqlDialect createDialect(DataSource dataSource) {
        return JdbcSchema.createDialect(SqlDialectFactoryImpl.INSTANCE, dataSource);
    }

    public static SqlDialect createDialect(SqlDialectFactory dialectFactory, DataSource dataSource) {
        return JdbcUtils.DialectPool.INSTANCE.get(dialectFactory, dataSource);
    }

    public static DataSource dataSource(String url, @Nullable String driverClassName, @Nullable String username, @Nullable String password) {
        if (url.startsWith("jdbc:hsqldb:")) {
            System.setProperty("hsqldb.reconfig_logging", "false");
        }
        return JdbcUtils.DataSourcePool.INSTANCE.get(url, driverClassName, username, password);
    }

    @Override
    public Lookup<Table> tables() {
        return this.tables.getOrCompute(() -> new IgnoreCaseLookup<Table>(){

            @Override
            public @Nullable Table get(String name) {
                try (Stream s = JdbcSchema.this.getMetaTableStream(name);){
                    Table table = s.findFirst().map((? super T it) -> JdbcSchema.this.jdbcTableMapper(it)).orElse(null);
                    return table;
                }
            }

            @Override
            public Set<String> getNames(LikePattern pattern) {
                try (Stream s = JdbcSchema.this.getMetaTableStream(pattern.pattern);){
                    Set<String> set = s.map((? super T it) -> it.tableName).collect(Collectors.toSet());
                    return set;
                }
            }
        });
    }

    @Override
    public Lookup<? extends Schema> subSchemas() {
        return this.subSchemas;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Schema snapshot(SchemaVersion version) {
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Expression getExpression(@Nullable SchemaPlus parentSchema, String name) {
        Objects.requireNonNull(parentSchema, "parentSchema must not be null for JdbcSchema");
        return Schemas.subSchemaExpression(parentSchema, name, JdbcSchema.class);
    }

    private Stream<MetaImpl.MetaTable> getMetaTableStream(String tableNamePattern) {
        Stream<MetaImpl.MetaTable> tableDefs;
        Pair<@Nullable String, @Nullable String> catalogSchema = this.getCatalogSchema();
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            resultSet = metaData.getTables((String)catalogSchema.left, (String)catalogSchema.right, tableNamePattern, null);
            tableDefs = JdbcSchema.asStream(connection, resultSet).map(JdbcSchema::metaDataMapper);
        }
        catch (SQLException e) {
            JdbcSchema.close(connection, null, resultSet);
            throw new RuntimeException("Exception while reading tables", e);
        }
        return tableDefs;
    }

    private static Stream<ResultSet> asStream(Connection connection, final ResultSet resultSet) {
        return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<ResultSet>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super ResultSet> action) {
                try {
                    if (!resultSet.next()) {
                        return false;
                    }
                    action.accept(resultSet);
                    return true;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, false).onClose(() -> JdbcSchema.close(connection, null, resultSet));
    }

    private JdbcTable jdbcTableMapper(MetaImpl.MetaTable tableDef) {
        return new JdbcTable(this, tableDef.tableCat, tableDef.tableSchem, tableDef.tableName, JdbcSchema.getTableType(tableDef.tableType));
    }

    private static MetaImpl.MetaTable metaDataMapper(ResultSet resultSet) {
        try {
            return new MetaImpl.MetaTable(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Schema.TableType getTableType(String tableTypeName) {
        String tableTypeName2 = tableTypeName == null ? null : tableTypeName.toUpperCase(Locale.ROOT).replace(' ', '_');
        Schema.TableType tableType = Util.enumVal(Schema.TableType.OTHER, tableTypeName2);
        if (tableType == Schema.TableType.OTHER && tableTypeName2 != null) {
            LOGGER.info("Unknown table type: {}", (Object)tableTypeName2);
        }
        return tableType;
    }

    private static List<Integer> version(DatabaseMetaData metaData) throws SQLException {
        return ImmutableList.of((Object)metaData.getJDBCMajorVersion(), (Object)metaData.getJDBCMinorVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<@Nullable String, @Nullable String> getCatalogSchema() {
        try (Connection connection = this.dataSource.getConnection();){
            boolean jdbc41OrAbove;
            DatabaseMetaData metaData = connection.getMetaData();
            ImmutableList version41 = ImmutableList.of((Object)4, (Object)1);
            String catalog = this.catalog;
            String schema = this.schema;
            boolean bl = jdbc41OrAbove = VERSION_ORDERING.compare(JdbcSchema.version(metaData), (Object)version41) >= 0;
            if (catalog == null && jdbc41OrAbove) {
                catalog = connection.getCatalog();
            }
            if (schema == null && jdbc41OrAbove && "".equals(schema = connection.getSchema())) {
                schema = null;
            }
            if ((catalog == null || schema == null) && metaData.getDatabaseProductName().equals("PostgreSQL")) {
                String sql = "select current_database(), current_schema()";
                try (Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery("select current_database(), current_schema()");){
                    if (resultSet.next()) {
                        catalog = resultSet.getString(1);
                        schema = resultSet.getString(2);
                    }
                }
            }
            Pair<String, String> pair = Pair.of(catalog, schema);
            return pair;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelProtoDataType getRelDataType(String catalogName, String schemaName, String tableName) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            RelProtoDataType relProtoDataType = this.getRelDataType(metaData, catalogName, schemaName, tableName);
            return relProtoDataType;
        }
        finally {
            JdbcSchema.close(connection, null, null);
        }
    }

    RelProtoDataType getRelDataType(DatabaseMetaData metaData, String catalogName, String schemaName, String tableName) throws SQLException {
        ResultSet resultSet = metaData.getColumns(catalogName, schemaName, tableName, null);
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        while (resultSet.next()) {
            int scale;
            int precision;
            String columnName = Objects.requireNonNull(resultSet.getString(4), "columnName");
            int dataType = resultSet.getInt(5);
            String typeString = resultSet.getString(6);
            switch (SqlType.valueOf((int)dataType)) {
                case TIMESTAMP: 
                case TIME: {
                    precision = resultSet.getInt(9);
                    scale = 0;
                    break;
                }
                default: {
                    precision = resultSet.getInt(7);
                    scale = resultSet.getInt(9);
                }
            }
            RelDataType sqlType = JdbcSchema.sqlType(typeFactory, dataType, precision, scale, typeString);
            boolean nullable = resultSet.getInt(11) != 0;
            ((RelDataTypeFactory.Builder)fieldInfo).add(columnName, sqlType).nullable(nullable);
        }
        resultSet.close();
        return RelDataTypeImpl.proto(fieldInfo.build());
    }

    private static RelDataType sqlType(RelDataTypeFactory typeFactory, int dataType, int precision, int scale, @Nullable String typeString) {
        SqlTypeName sqlTypeName = Util.first(SqlTypeName.getNameForJdbcType(dataType), SqlTypeName.ANY);
        switch (sqlTypeName) {
            case ARRAY: {
                RelDataType component = null;
                if (typeString != null && typeString.endsWith(" ARRAY")) {
                    String remaining = typeString.substring(0, typeString.length() - " ARRAY".length());
                    component = JdbcSchema.parseTypeString(typeFactory, remaining);
                }
                if (component == null) {
                    component = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
                }
                return typeFactory.createArrayType(component, -1L);
            }
        }
        if (precision >= 0 && scale >= 0 && sqlTypeName.allowsPrecScale(true, true)) {
            return typeFactory.createSqlType(sqlTypeName, precision, scale);
        }
        if (precision >= 0 && sqlTypeName.allowsPrecNoScale()) {
            return typeFactory.createSqlType(sqlTypeName, precision);
        }
        assert (sqlTypeName.allowsNoPrecNoScale());
        return typeFactory.createSqlType(sqlTypeName);
    }

    private static RelDataType parseTypeString(RelDataTypeFactory typeFactory, String typeString) {
        int close;
        int precision = -1;
        int scale = -1;
        int open = typeString.indexOf("(");
        if (open >= 0 && (close = typeString.indexOf(")", open)) >= 0) {
            String rest = typeString.substring(open + 1, close);
            typeString = typeString.substring(0, open);
            int comma = rest.indexOf(",");
            if (comma >= 0) {
                precision = Integer.parseInt(rest.substring(0, comma));
                scale = Integer.parseInt(rest.substring(comma));
            } else {
                precision = Integer.parseInt(rest);
            }
        }
        try {
            SqlTypeName typeName = SqlTypeName.valueOf(typeString);
            return typeName.allowsPrecScale(true, true) ? typeFactory.createSqlType(typeName, precision, scale) : (typeName.allowsPrecScale(true, false) ? typeFactory.createSqlType(typeName, precision) : typeFactory.createSqlType(typeName));
        }
        catch (IllegalArgumentException e) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
    }

    public <T> @Nullable T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz == DataSource.class) {
            return clazz.cast(this.getDataSource());
        }
        return null;
    }

    private static void close(@Nullable Connection connection, @Nullable Statement statement, @Nullable ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static interface Foo
    extends BiFunction<String, String, Iterable<MetaImpl.MetaTable>> {
    }

    public static class Factory
    implements SchemaFactory {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            return JdbcSchema.create(parentSchema, name, operand);
        }
    }
}

