/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.OutNetworkObject;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite.internal.network.serialization.MessageFormat;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.internal.util.ArrayUtils;

public class OutboundEncoder
extends MessageToMessageEncoder<OutNetworkObject> {
    public static final String NAME = "outbound-encoder";
    private static final int IO_BUFFER_CAPACITY = 16384;
    private static final NetworkMessagesFactory MSG_FACTORY = new NetworkMessagesFactory();
    private static final AttributeKey<MessageWriter> WRITER_KEY = AttributeKey.valueOf((String)"WRITER");
    private final MessageFormat messageFormat;
    private final PerSessionSerializationService serializationService;

    public OutboundEncoder(MessageFormat messageFormat, PerSessionSerializationService serializationService) {
        this.messageFormat = messageFormat;
        this.serializationService = serializationService;
    }

    protected void encode(ChannelHandlerContext ctx, OutNetworkObject msg, List<Object> out) throws Exception {
        Attribute writerAttr = ctx.channel().attr(WRITER_KEY);
        MessageWriter writer = (MessageWriter)writerAttr.get();
        if (writer == null) {
            writer = this.messageFormat.writer(this.serializationService.serializationRegistry(), (byte)1);
            writerAttr.set((Object)writer);
        }
        out.add(new NetworkMessageChunkedInput(msg, this.serializationService, writer));
    }

    private static class NetworkMessageChunkedInput
    implements ChunkedInput<ByteBuf> {
        private final NetworkMessage msg;
        private final MessageSerializer<NetworkMessage> serializer;
        private final MessageSerializer<ClassDescriptorListMessage> descriptorSerializer;
        private final MessageWriter writer;
        private final ClassDescriptorListMessage descriptors;
        private final PerSessionSerializationService serializationService;
        private boolean finished = false;
        private boolean descriptorsFinished = false;

        private NetworkMessageChunkedInput(OutNetworkObject outObject, PerSessionSerializationService serializationService, MessageWriter writer) {
            this.serializationService = serializationService;
            this.msg = outObject.networkMessage();
            ArrayList<ClassDescriptorMessage> outDescriptors = null;
            List<ClassDescriptorMessage> outObjectDescriptors = outObject.descriptors();
            int descriptorsSize = outObjectDescriptors.size();
            for (int i = 0; i < descriptorsSize; ++i) {
                ClassDescriptorMessage classDescriptorMessage = outObjectDescriptors.get(i);
                if (serializationService.isDescriptorSent(classDescriptorMessage.descriptorId())) continue;
                if (outDescriptors == null) {
                    outDescriptors = new ArrayList<ClassDescriptorMessage>(outObject.descriptors().size());
                }
                outDescriptors.add(classDescriptorMessage);
            }
            if (outDescriptors != null) {
                this.descriptors = MSG_FACTORY.classDescriptorListMessage().messages(outDescriptors).build();
                short groupType = this.descriptors.groupType();
                short messageType = this.descriptors.messageType();
                this.descriptorSerializer = serializationService.createMessageSerializer(groupType, messageType);
            } else {
                this.descriptors = null;
                this.descriptorSerializer = null;
                this.descriptorsFinished = true;
            }
            this.serializer = serializationService.createMessageSerializer(this.msg.groupType(), this.msg.messageType());
            this.writer = writer;
        }

        public boolean isEndOfInput() {
            return this.finished;
        }

        public void close() {
        }

        @Deprecated
        public ByteBuf readChunk(ChannelHandlerContext ctx) {
            return this.readChunk(ctx.alloc());
        }

        public ByteBuf readChunk(ByteBufAllocator allocator) {
            ByteBuf buffer = allocator.ioBuffer(16384);
            int capacity = buffer.capacity();
            ByteBuffer byteBuffer = buffer.internalNioBuffer(0, capacity);
            int initialPosition = byteBuffer.position();
            this.writer.setBuffer(byteBuffer);
            while (byteBuffer.hasRemaining()) {
                if (!this.descriptorsFinished) {
                    this.descriptorsFinished = this.descriptorSerializer.writeMessage((NetworkMessage)this.descriptors, this.writer);
                    if (!this.descriptorsFinished) break;
                    for (ClassDescriptorMessage classDescriptorMessage : this.descriptors.messages()) {
                        this.serializationService.addSentDescriptor(classDescriptorMessage.descriptorId());
                    }
                    this.writer.reset();
                    continue;
                }
                this.finished = this.serializer.writeMessage(this.msg, this.writer);
                if (!this.finished) break;
                this.writer.reset();
                break;
            }
            buffer.writerIndex(byteBuffer.position() - initialPosition);
            this.writer.setBuffer(ArrayUtils.EMPTY_BYTE_BUFFER);
            return buffer;
        }

        public long length() {
            return -1L;
        }

        public long progress() {
            return 0L;
        }
    }
}

