/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.ClusterStatePersistentSerializer;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNodeSerializer;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

public class ClusterStateStorageManager {
    private static final byte[] CMG_STATE_KEY = "cmg_state".getBytes(StandardCharsets.UTF_8);
    private static final byte[] VALIDATED_NODE_PREFIX = "validation_".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METASTORAGE_REPAIRING_CONFIG_INDEX_KEY = "metastorageRepairingConfigIndex".getBytes(StandardCharsets.UTF_8);
    private final ClusterStateStorage storage;

    public ClusterStateStorageManager(ClusterStateStorage storage) {
        this.storage = storage;
    }

    @Nullable
    public ClusterState getClusterState() {
        byte[] value = this.storage.get(CMG_STATE_KEY);
        return value == null ? null : (ClusterState)VersionedSerialization.fromBytes((byte[])value, (VersionedSerializer)ClusterStatePersistentSerializer.INSTANCE);
    }

    public void putClusterState(ClusterState state) {
        this.storage.put(CMG_STATE_KEY, VersionedSerialization.toBytes((Object)state, (VersionedSerializer)ClusterStatePersistentSerializer.INSTANCE));
    }

    boolean isNodeValidated(LogicalNode node) {
        byte[] value = this.storage.get(ClusterStateStorageManager.validatedNodeKey(node.id()));
        return value != null;
    }

    void putValidatedNode(LogicalNode node) {
        this.storage.put(ClusterStateStorageManager.validatedNodeKey(node.id()), VersionedSerialization.toBytes((Object)((Object)node), (VersionedSerializer)LogicalNodeSerializer.INSTANCE));
    }

    void removeValidatedNode(LogicalNode node) {
        this.storage.remove(ClusterStateStorageManager.validatedNodeKey(node.id()));
    }

    private static byte[] validatedNodeKey(UUID nodeId) {
        byte[] nodeIdBytes = ByteUtils.uuidToBytes((UUID)nodeId);
        return ByteBuffer.allocate(VALIDATED_NODE_PREFIX.length + nodeIdBytes.length).put(VALIDATED_NODE_PREFIX).put(nodeIdBytes).array();
    }

    List<LogicalNode> getValidatedNodes() {
        return this.storage.getWithPrefix(VALIDATED_NODE_PREFIX, (k, v) -> (LogicalNode)((Object)((Object)VersionedSerialization.fromBytes((byte[])v, (VersionedSerializer)LogicalNodeSerializer.INSTANCE))));
    }

    void saveMetastorageRepairInfo(long repairingConfigIndex) {
        this.storage.put(METASTORAGE_REPAIRING_CONFIG_INDEX_KEY, ByteUtils.longToBytes((long)repairingConfigIndex));
    }

    @Nullable
    Long getMetastorageRepairingConfigIndex() {
        byte[] bytes = this.storage.get(METASTORAGE_REPAIRING_CONFIG_INDEX_KEY);
        return bytes == null ? null : Long.valueOf(ByteUtils.bytesToLong((byte[])bytes));
    }

    CompletableFuture<Void> snapshot(Path snapshotPath) {
        return this.storage.snapshot(snapshotPath);
    }

    void restoreSnapshot(Path snapshotPath) {
        this.storage.restoreSnapshot(snapshotPath);
    }
}

