/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.metrics;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.StringGauge;
import org.apache.ignite.internal.metrics.UuidGauge;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.properties.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class LocalTopologyMetricsSource
extends AbstractMetricSource<Holder> {
    static final String SOURCE_NAME = "topology.local";
    private final TopologyService physicalTopology;

    public LocalTopologyMetricsSource(TopologyService physicalTopology) {
        super(SOURCE_NAME, "Local topology metrics.", "topology");
        this.physicalTopology = physicalTopology;
    }

    protected Holder createHolder() {
        return new Holder();
    }

    public String localNodeName() {
        Holder h = (Holder)this.holder();
        if (h == null) {
            return "";
        }
        return h.localNodeName.value();
    }

    @Nullable
    public UUID localNodeId() {
        Holder h = (Holder)this.holder();
        if (h == null) {
            return null;
        }
        return h.localNodeId.value();
    }

    public String localNodeVersion() {
        Holder h = (Holder)this.holder();
        if (h == null) {
            return "";
        }
        return h.localNodeVersion.value();
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final StringGauge localNodeVersion = new StringGauge("NodeVersion", "Ignite product version", () -> ((IgniteProductVersion)IgniteProductVersion.CURRENT_VERSION).toString());
        private final UuidGauge localNodeId = new UuidGauge("NodeId", "Unique identifier of the local node", () -> LocalTopologyMetricsSource.this.physicalTopology.localMember().id());
        private final StringGauge localNodeName = new StringGauge("NodeName", "Unique name of the local node", () -> LocalTopologyMetricsSource.this.physicalTopology.localMember().name());
        private final List<Metric> metrics = List.of(this.localNodeName, this.localNodeId, this.localNodeVersion);

        protected Holder() {
        }

        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

