/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.ChangeIndexStatusValidationException;
import org.apache.ignite.internal.catalog.IndexNotFoundValidationException;
import org.apache.ignite.internal.catalog.commands.MakeIndexAvailableCommand;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;

class IndexManagementUtils {
    private static final String IN_PROGRESS_BUILD_INDEX_KEY_PREFIX = "indexBuild.inProgress.";
    static final String PARTITION_BUILD_INDEX_KEY_PREFIX = "indexBuild.partition.";
    static final long AWAIT_PRIMARY_REPLICA_TIMEOUT_SEC = 10L;

    IndexManagementUtils() {
    }

    static boolean isMetastoreKeyAbsentLocally(MetaStorageManager metastore, ByteArray key, long revUpperBound) {
        return metastore.getLocally(key, revUpperBound).value() == null;
    }

    static boolean isAnyMetastoreKeyPresentLocally(MetaStorageManager metastore, ByteArray keyPrefix, long revUpperBound) {
        try (Cursor cursor = metastore.prefixLocally(keyPrefix, revUpperBound);){
            boolean bl = cursor.stream().map(Entry::value).anyMatch(Objects::nonNull);
            return bl;
        }
    }

    static CompletableFuture<Boolean> removeMetastoreKeyIfPresent(MetaStorageManager metaStorageManager, ByteArray key) {
        return metaStorageManager.invoke((Condition)Conditions.exists((ByteArray)key), Operations.remove((ByteArray)key), Operations.noop());
    }

    static CompletableFuture<Boolean> putBuildIndexMetastoreKeysIfAbsent(MetaStorageManager metastore, int indexId, int partitions) {
        ByteArray inProgressBuildIndexMetastoreKey = IndexManagementUtils.inProgressBuildIndexMetastoreKey(indexId);
        List putPartitionBuildIndexMetastoreKeyOperations = IntStream.range(0, partitions).mapToObj(partitionId -> Operations.put((ByteArray)IndexManagementUtils.partitionBuildIndexMetastoreKey(indexId, partitionId), (byte[])ArrayUtils.BYTE_EMPTY_ARRAY)).collect(Collectors.toList());
        return metastore.invoke((Condition)Conditions.notExists((ByteArray)inProgressBuildIndexMetastoreKey), CollectionUtils.concat((List[])new List[]{List.of(Operations.put((ByteArray)inProgressBuildIndexMetastoreKey, (byte[])ArrayUtils.BYTE_EMPTY_ARRAY)), putPartitionBuildIndexMetastoreKeyOperations}), List.of(Operations.noop()));
    }

    static ByteArray inProgressBuildIndexMetastoreKey(int indexId) {
        return ByteArray.fromString((String)(IN_PROGRESS_BUILD_INDEX_KEY_PREFIX + indexId));
    }

    static ByteArray partitionBuildIndexMetastoreKeyPrefix(int indexId) {
        return ByteArray.fromString((String)(PARTITION_BUILD_INDEX_KEY_PREFIX + indexId));
    }

    static ByteArray partitionBuildIndexMetastoreKey(int indexId, int partitionId) {
        return ByteArray.fromString((String)(PARTITION_BUILD_INDEX_KEY_PREFIX + indexId + "." + partitionId));
    }

    static String toPartitionBuildIndexMetastoreKeyString(byte[] bytes) {
        String keyStr = new String(bytes, StandardCharsets.UTF_8);
        assert (keyStr.startsWith(PARTITION_BUILD_INDEX_KEY_PREFIX)) : keyStr;
        return keyStr;
    }

    static int getPartitionCountFromCatalog(Catalog catalog, int indexId) {
        assert (catalog != null) : "catalog";
        CatalogIndexDescriptor indexDescriptor = catalog.index(indexId);
        assert (indexDescriptor != null) : "indexId=" + indexId + ", catalogVersion=" + catalog.version();
        CatalogTableDescriptor tableDescriptor = catalog.table(indexDescriptor.tableId());
        assert (tableDescriptor != null) : "tableId=" + indexDescriptor.tableId() + ", catalogVersion=" + catalog.version();
        CatalogZoneDescriptor zoneDescriptor = catalog.zone(tableDescriptor.zoneId());
        assert (zoneDescriptor != null) : "zoneId=" + tableDescriptor.zoneId() + ", catalogVersion=" + catalog.version();
        return zoneDescriptor.partitions();
    }

    static CatalogIndexDescriptor index(CatalogService catalogService, int indexId, int catalogVersion) {
        CatalogIndexDescriptor indexDescriptor = catalogService.catalog(catalogVersion).index(indexId);
        assert (indexDescriptor != null) : "indexId=" + indexId + ", catalogVersion=" + catalogVersion;
        return indexDescriptor;
    }

    static void makeIndexAvailableInCatalogWithoutFuture(CatalogManager catalogManager, int indexId, FailureProcessor failureProcessor) {
        catalogManager.execute(MakeIndexAvailableCommand.builder().indexId(indexId).build()).whenComplete((unused, throwable) -> {
            Throwable unwrappedCause;
            if (!(throwable == null || (unwrappedCause = ExceptionUtils.unwrapCause((Throwable)throwable)) instanceof IndexNotFoundValidationException || unwrappedCause instanceof ChangeIndexStatusValidationException || unwrappedCause instanceof NodeStoppingException)) {
                String errorMessage = "Error processing the command to make the index available: " + indexId;
                failureProcessor.process(new FailureContext(throwable, errorMessage));
            }
        });
    }

    static int extractPartitionIdFromPartitionBuildIndexKey(String key) {
        assert (key.startsWith(PARTITION_BUILD_INDEX_KEY_PREFIX)) : key;
        String[] strings = key.split("\\.");
        return Integer.parseInt(strings[3]);
    }

    static int extractIndexIdFromPartitionBuildIndexKey(String key) {
        assert (key.startsWith(PARTITION_BUILD_INDEX_KEY_PREFIX)) : key;
        String[] strings = key.split("\\.");
        return Integer.parseInt(strings[2]);
    }

    static boolean isPrimaryReplica(ReplicaMeta primaryReplicaMeta, InternalClusterNode localNode, HybridTimestamp timestamp) {
        return localNode.id().equals(primaryReplicaMeta.getLeaseholderId()) && timestamp.compareTo(primaryReplicaMeta.getExpirationTime()) < 0;
    }

    static InternalClusterNode localNode(ClusterService clusterService) {
        return clusterService.topologyService().localMember();
    }

    static boolean isLocalNode(ClusterService clusterService, UUID nodeId) {
        return nodeId.equals(IndexManagementUtils.localNode(clusterService).id());
    }

    static boolean enterBusy(IgniteSpinBusyLock busyLock0, IgniteSpinBusyLock busyLock1) {
        if (!busyLock0.enterBusy()) {
            return false;
        }
        if (!busyLock1.enterBusy()) {
            busyLock0.leaveBusy();
            return false;
        }
        return true;
    }

    static void leaveBusy(IgniteSpinBusyLock busyLock0, IgniteSpinBusyLock busyLock1) {
        busyLock1.leaveBusy();
        busyLock0.leaveBusy();
    }
}

