/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.jetbrains.annotations.Nullable;

public class DataStorageModules {
    private final Map<String, DataStorageModule> modules;

    public DataStorageModules(Iterable<DataStorageModule> dataStorageModules) {
        HashMap<String, DataStorageModule> modules = new HashMap<String, DataStorageModule>();
        for (DataStorageModule module : dataStorageModules) {
            String name = module.name();
            if (modules.containsKey(name)) {
                throw new IllegalStateException(String.format("Duplicate name [name=%s, factories=%s]", name, List.of((DataStorageModule)modules.get(name), module)));
            }
            modules.put(name, module);
        }
        assert (!modules.isEmpty());
        this.modules = modules;
    }

    public Map<String, StorageEngine> createStorageEngines(String igniteInstanceName, MetricManager metricManager, ConfigurationRegistry configRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, LogSyncer logSyncer, HybridClock clock, ScheduledExecutorService commonScheduler) {
        return this.modules.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((DataStorageModule)e.getValue()).createEngine(igniteInstanceName, metricManager, configRegistry, storagePath, longJvmPauseDetector, failureManager, logSyncer, clock, commonScheduler)));
    }
}

