/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.mapping.ColumnMapping;
import org.apache.ignite.internal.schema.registry.SchemaDescriptorLoader;
import org.apache.ignite.internal.schema.registry.SchemaRegistrationConflictException;
import org.apache.ignite.internal.schema.registry.SchemaRegistryException;
import org.apache.ignite.internal.schema.registry.UpgradingRowAdapter;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.jetbrains.annotations.Nullable;

public class SchemaRegistryImpl
implements SchemaRegistry {
    private final ConcurrentNavigableMap<Integer, SchemaDescriptor> schemaCache = new ConcurrentSkipListMap<Integer, SchemaDescriptor>();
    private final Map<Long, ColumnMapper> mappingCache = new ConcurrentHashMap<Long, ColumnMapper>();
    private final SchemaDescriptorLoader schemaDescriptorLoader;
    private final PendingComparableValuesTracker<Integer, Void> versionTracker = new PendingComparableValuesTracker((Comparable)Integer.valueOf(0));
    private final InFlightFutures inFlightTableSchemaFutures = new InFlightFutures();

    public SchemaRegistryImpl(SchemaDescriptorLoader schemaDescriptorLoader, SchemaDescriptor initialSchema) {
        this.schemaDescriptorLoader = schemaDescriptorLoader;
        this.makeSchemaVersionAvailable(initialSchema);
    }

    private void makeSchemaVersionAvailable(SchemaDescriptor desc) {
        this.schemaCache.putIfAbsent(desc.version(), desc);
        this.versionTracker.update((Comparable)Integer.valueOf(desc.version()), null);
    }

    @Override
    public SchemaDescriptor lastKnownSchema() {
        return this.schema(this.lastKnownSchemaVersion());
    }

    @Override
    public SchemaDescriptor schema(int version) {
        int actualVersion = this.versionOrLatestForZero(version);
        SchemaDescriptor desc = this.getFromCacheOrLoad(actualVersion);
        if (desc != null) {
            return desc;
        }
        if (actualVersion <= 0 || actualVersion > (Integer)this.schemaCache.lastKey()) {
            throw new SchemaRegistryException("Incorrect schema version requested: ver=" + actualVersion);
        }
        throw SchemaRegistryImpl.failedToFindSchemaException(actualVersion);
    }

    @Nullable
    private SchemaDescriptor getFromCacheOrLoad(int version) {
        SchemaDescriptor desc = (SchemaDescriptor)this.schemaCache.get(version);
        if (desc != null) {
            return desc;
        }
        desc = this.loadStoredSchemaByVersion(version);
        if (desc != null) {
            this.makeSchemaVersionAvailable(desc);
        }
        return desc;
    }

    private static SchemaRegistryException failedToFindSchemaException(int version) {
        return new SchemaRegistryException("Failed to find schema (was it compacted away?) [version=" + version + "]");
    }

    private int versionOrLatestForZero(int version) {
        if (version == 0) {
            return (Integer)this.schemaCache.lastKey();
        }
        return version;
    }

    @Override
    public CompletableFuture<SchemaDescriptor> schemaAsync(int version) {
        if (version <= 0) {
            return CompletableFuture.failedFuture((Throwable)((Object)new SchemaRegistryException("Unsupported schema version [version=" + version + "]")));
        }
        SchemaDescriptor desc = this.getFromCacheOrLoad(version);
        if (desc != null) {
            return CompletableFuture.completedFuture(desc);
        }
        return this.tableSchemaAsync(version).whenComplete((loadedDesc, ex) -> {
            if (ex == null) {
                if (loadedDesc == null) {
                    throw SchemaRegistryImpl.failedToFindSchemaException(version);
                }
                this.makeSchemaVersionAvailable((SchemaDescriptor)loadedDesc);
            }
        });
    }

    @Override
    public int lastKnownSchemaVersion() {
        return (Integer)this.schemaCache.lastKey();
    }

    @Override
    public Row resolve(BinaryRow row, int targetSchemaVersion) {
        SchemaDescriptor targetSchema = this.schema(targetSchemaVersion);
        SchemaRegistryImpl.throwIfNoSuchSchema(targetSchema, targetSchemaVersion);
        return this.resolveInternal(row, targetSchema, false);
    }

    @Override
    public Row resolve(BinaryRow row, SchemaDescriptor schemaDescriptor) {
        return this.resolveInternal(row, schemaDescriptor, false);
    }

    @Override
    public List<Row> resolve(Collection<BinaryRow> binaryRows, int targetSchemaVersion) {
        return this.resolveInternal(binaryRows, targetSchemaVersion, false);
    }

    private static void throwIfNoSuchSchema(SchemaDescriptor targetSchema, int targetSchemaVersion) {
        if (targetSchema == null) {
            throw new SchemaRegistryException("No schema found: schemaVersion=" + targetSchemaVersion);
        }
    }

    @Override
    public List<Row> resolveKeys(Collection<BinaryRow> keyOnlyRows, int targetSchemaVersion) {
        return this.resolveInternal(keyOnlyRows, targetSchemaVersion, true);
    }

    @Override
    public void close() {
        this.versionTracker.close();
        this.inFlightTableSchemaFutures.cancelInFlightFutures();
    }

    private Row resolveInternal(BinaryRow binaryRow, SchemaDescriptor targetSchema, boolean keyOnly) {
        if (binaryRow.schemaVersion() == 0 || targetSchema.version() == binaryRow.schemaVersion()) {
            return keyOnly ? Row.wrapKeyOnlyBinaryRow(targetSchema, binaryRow) : Row.wrapBinaryRow(targetSchema, binaryRow);
        }
        SchemaDescriptor rowSchema = this.schema(binaryRow.schemaVersion());
        ColumnMapper mapping = this.resolveMapping(targetSchema, rowSchema);
        if (keyOnly) {
            Row row = Row.wrapKeyOnlyBinaryRow(rowSchema, binaryRow);
            return UpgradingRowAdapter.upgradeKeyOnlyRow(targetSchema, mapping, row);
        }
        Row row = Row.wrapBinaryRow(rowSchema, binaryRow);
        return UpgradingRowAdapter.upgradeRow(targetSchema, mapping, row);
    }

    private List<Row> resolveInternal(Collection<BinaryRow> binaryRows, int targetSchemaVersion, boolean keyOnly) {
        SchemaDescriptor targetSchema = this.schema(targetSchemaVersion);
        SchemaRegistryImpl.throwIfNoSuchSchema(targetSchema, targetSchemaVersion);
        ArrayList<Row> rows = new ArrayList<Row>(binaryRows.size());
        for (BinaryRow row : binaryRows) {
            rows.add(row == null ? null : this.resolveInternal(row, targetSchema, keyOnly));
        }
        return rows;
    }

    private ColumnMapper resolveMapping(SchemaDescriptor curSchema, SchemaDescriptor rowSchema) {
        assert (curSchema.version() > rowSchema.version());
        if (curSchema.version() == rowSchema.version() + 1) {
            return curSchema.columnMapping();
        }
        long mappingKey = (long)curSchema.version() << 32 | (long)rowSchema.version();
        ColumnMapper mapping = this.mappingCache.get(mappingKey);
        if (mapping != null) {
            return mapping;
        }
        mapping = this.schema(rowSchema.version() + 1).columnMapping();
        for (int i = rowSchema.version() + 2; i <= curSchema.version(); ++i) {
            mapping = ColumnMapping.mergeMapping(mapping, this.schema(i));
        }
        this.mappingCache.putIfAbsent(mappingKey, mapping);
        return mapping;
    }

    public void onSchemaRegistered(SchemaDescriptor desc) {
        int lastVer = (Integer)this.schemaCache.lastKey();
        if (desc.version() != lastVer + 1) {
            if (desc.version() > 0 && desc.version() <= lastVer) {
                throw new SchemaRegistrationConflictException("Schema with given version has been already registered: " + desc.version());
            }
            throw new SchemaRegistryException("Try to register schema of wrong version: ver=" + desc.version() + ", lastVer=" + lastVer);
        }
        this.makeSchemaVersionAvailable(desc);
    }

    private CompletableFuture<SchemaDescriptor> tableSchemaAsync(int schemaVer) {
        if (schemaVer < this.lastKnownSchemaVersion()) {
            return CompletableFuture.completedFuture(this.loadStoredSchemaByVersion(schemaVer));
        }
        CompletionStage future = this.versionTracker.waitFor((Comparable)Integer.valueOf(schemaVer)).thenApply(unused -> (SchemaDescriptor)this.schemaCache.get(schemaVer));
        this.inFlightTableSchemaFutures.registerFuture((CompletableFuture)future);
        return future;
    }

    @Nullable
    private SchemaDescriptor loadStoredSchemaByVersion(int schemaVer) {
        return this.schemaDescriptorLoader.load(schemaVer);
    }
}

