/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.binarytuple.ByteBufferAccessor;
import org.apache.ignite.internal.util.GridUnsafe;

public class UnsafeByteBufferAccessor
implements ByteBufferAccessor {
    private static final boolean REVERSE_BYTE_ORDER = GridUnsafe.NATIVE_BYTE_ORDER != BinaryTupleParser.ORDER;
    private final byte[] bytes;
    private final long addr;
    private final int capacity;

    public UnsafeByteBufferAccessor(ByteBuffer buff) {
        if (buff.isDirect()) {
            this.bytes = null;
            this.addr = GridUnsafe.bufferAddress((ByteBuffer)buff);
        } else {
            this.bytes = buff.array();
            this.addr = GridUnsafe.BYTE_ARR_OFF + (long)buff.arrayOffset();
        }
        this.capacity = buff.capacity();
    }

    public byte get(int p) {
        return GridUnsafe.getByte((byte[])this.bytes, (long)(this.addr + (long)p));
    }

    public int getInt(int p) {
        int value = GridUnsafe.getInt((byte[])this.bytes, (long)(this.addr + (long)p));
        return REVERSE_BYTE_ORDER ? Integer.reverseBytes(value) : value;
    }

    public long getLong(int p) {
        long value = GridUnsafe.getLong((byte[])this.bytes, (long)(this.addr + (long)p));
        return REVERSE_BYTE_ORDER ? Long.reverseBytes(value) : value;
    }

    public short getShort(int p) {
        short value = GridUnsafe.getShort((byte[])this.bytes, (long)(this.addr + (long)p));
        return REVERSE_BYTE_ORDER ? Short.reverseBytes(value) : value;
    }

    public float getFloat(int p) {
        float value = GridUnsafe.getFloat((byte[])this.bytes, (long)(this.addr + (long)p));
        return REVERSE_BYTE_ORDER ? Float.intBitsToFloat(Integer.reverseBytes(Float.floatToIntBits(value))) : value;
    }

    public double getDouble(int p) {
        double value = GridUnsafe.getDouble((byte[])this.bytes, (long)(this.addr + (long)p));
        return REVERSE_BYTE_ORDER ? Double.longBitsToDouble(Long.reverseBytes(Double.doubleToLongBits(value))) : value;
    }

    public int capacity() {
        return this.capacity;
    }

    public byte[] getArray() {
        return this.bytes;
    }

    public long getAddress() {
        return this.addr;
    }
}

