/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.sse.Event;
import io.micronaut.reactor.http.client.sse.BridgedReactorSseClient;
import java.net.URL;
import reactor.core.publisher.Flux;

public interface ReactorSseClient
extends SseClient {
    public <I> Flux<Event<ByteBuffer<?>>> eventStream(@NonNull HttpRequest<I> var1);

    public <I, B> Flux<Event<B>> eventStream(@NonNull HttpRequest<I> var1, @NonNull Argument<B> var2);

    public <I, B> Flux<Event<B>> eventStream(@NonNull HttpRequest<I> var1, @NonNull Class<B> var2);

    public <B> Flux<Event<B>> eventStream(@NonNull String var1, @NonNull Class<B> var2);

    public <B> Flux<Event<B>> eventStream(@NonNull String var1, @NonNull Argument<B> var2);

    @NonNull
    public static ReactorSseClient create(@Nullable URL url) {
        return new BridgedReactorSseClient(SseClient.create((URL)url));
    }

    @NonNull
    public static ReactorSseClient create(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return new BridgedReactorSseClient(SseClient.create((URL)url, (HttpClientConfiguration)configuration));
    }
}

