/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceMinimumRequiredTimeProvider;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;

public class RebalanceMinimumRequiredTimeProviderImpl
implements RebalanceMinimumRequiredTimeProvider {
    private final MetaStorageManager metaStorageManager;
    private final CatalogService catalogService;

    public RebalanceMinimumRequiredTimeProviderImpl(MetaStorageManager metaStorageManager, CatalogService catalogService) {
        this.metaStorageManager = metaStorageManager;
        this.catalogService = catalogService;
    }

    @Override
    public long minimumRequiredTime() {
        HybridTimestamp metaStorageSafeTime;
        long appliedRevision = this.metaStorageManager.appliedRevision();
        HybridTimestamp minTimestamp = metaStorageSafeTime = this.metaStorageManager.timestampByRevisionLocally(appliedRevision);
        Map<Integer, Map<Integer, Assignments>> stableAssignments = this.readAssignments(RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES, appliedRevision);
        Map<Integer, Map<Integer, Assignments>> pendingAssignments = this.readPendingAssignments(appliedRevision);
        Map<Integer, HybridTimestamp> pendingChangeTriggerTimestamps = this.readPendingChangeTriggerTimestamps(RebalanceUtil.PENDING_CHANGE_TRIGGER_PREFIX_BYTES, appliedRevision);
        int earliestCatalogVersion = this.catalogService.earliestCatalogVersion();
        int latestCatalogVersion = this.catalogService.latestCatalogVersion();
        Map<Integer, Integer> tableIdToZoneIdMap = this.tableIdToZoneIdMap(earliestCatalogVersion, latestCatalogVersion);
        HashMap<HybridTimestamp, HybridTimestamp> updateTimestampsToActivationTimeMap = new HashMap<HybridTimestamp, HybridTimestamp>();
        Map<Integer, NavigableMap<HybridTimestamp, CatalogZoneDescriptor>> allZonesByTimestamp = this.allZonesByTimestamp(earliestCatalogVersion, latestCatalogVersion, updateTimestampsToActivationTimeMap);
        Map<Integer, HybridTimestamp> zoneDeletionTimestamps = this.zoneDeletionTimestamps(earliestCatalogVersion, latestCatalogVersion);
        for (Map.Entry<Integer, Integer> entry : tableIdToZoneIdMap.entrySet()) {
            Integer tableId = entry.getKey();
            Integer zoneId = entry.getValue();
            NavigableMap<HybridTimestamp, CatalogZoneDescriptor> zoneDescriptors = allZonesByTimestamp.get(zoneId);
            int zonePartitions = zoneDescriptors.lastEntry().getValue().partitions();
            HybridTimestamp pendingChangeTriggerTimestamp = pendingChangeTriggerTimestamps.get(tableId);
            HybridTimestamp latestTimestamp = HybridTimestamp.hybridTimestamp((long)(zoneDeletionTimestamps.getOrDefault(zoneId, metaStorageSafeTime.tick()).longValue() - 1L));
            HybridTimestamp zoneTimestamp = pendingChangeTriggerTimestamp == null ? zoneDescriptors.firstEntry().getValue().updateTimestamp() : pendingChangeTriggerTimestamp;
            NavigableMap<HybridTimestamp, CatalogZoneDescriptor> map = allZonesByTimestamp.get(zoneId);
            Map.Entry<HybridTimestamp, CatalogZoneDescriptor> zone = map.floorEntry(zoneTimestamp);
            HybridTimestamp timestamp = (HybridTimestamp)updateTimestampsToActivationTimeMap.get(zone.getValue().updateTimestamp());
            timestamp = RebalanceMinimumRequiredTimeProviderImpl.ceilTime(zoneDescriptors, timestamp, latestTimestamp);
            Map<Integer, Assignments> pendingTableAssignments = pendingAssignments.getOrDefault(tableId, Collections.emptyMap());
            if (!zoneDeletionTimestamps.containsKey(zoneId) || stableAssignments.get(tableId) != null || !pendingTableAssignments.isEmpty()) {
                minTimestamp = RebalanceMinimumRequiredTimeProviderImpl.min(minTimestamp, timestamp);
            }
            if (pendingTableAssignments.isEmpty()) continue;
            HybridTimestamp pendingTimestamp = RebalanceMinimumRequiredTimeProviderImpl.findProperTimestampForAssignments(pendingTableAssignments.size() == zonePartitions ? pendingTableAssignments : stableAssignments.getOrDefault(tableId, Collections.emptyMap()), zoneDescriptors, latestTimestamp);
            minTimestamp = RebalanceMinimumRequiredTimeProviderImpl.min(minTimestamp, pendingTimestamp);
        }
        return minTimestamp.longValue();
    }

    Map<Integer, NavigableMap<HybridTimestamp, CatalogZoneDescriptor>> allZonesByTimestamp(int earliestCatalogVersion, int latestCatalogVersion, Map<HybridTimestamp, HybridTimestamp> updateTimestampsToActivationTime) {
        HashMap<Integer, NavigableMap<HybridTimestamp, CatalogZoneDescriptor>> allZones = new HashMap<Integer, NavigableMap<HybridTimestamp, CatalogZoneDescriptor>>();
        for (int catalogVersion = earliestCatalogVersion; catalogVersion <= latestCatalogVersion; ++catalogVersion) {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            for (CatalogZoneDescriptor zone : catalog.zones()) {
                NavigableMap map = allZones.computeIfAbsent(zone.id(), id -> new TreeMap());
                if (!map.isEmpty() && !CatalogZoneDescriptor.updateRequiresAssignmentsRecalculation((CatalogZoneDescriptor)((CatalogZoneDescriptor)map.lastEntry().getValue()), (CatalogZoneDescriptor)zone)) continue;
                map.put(zone.updateTimestamp(), zone);
                updateTimestampsToActivationTime.put(zone.updateTimestamp(), HybridTimestamp.hybridTimestamp((long)catalog.time()));
            }
        }
        return allZones;
    }

    Map<Integer, HybridTimestamp> zoneDeletionTimestamps(int earliestCatalogVersion, int latestCatalogVersion) {
        HashSet<Integer> existingZoneIds = new HashSet<Integer>();
        HashMap<Integer, HybridTimestamp> zoneDeletionTimestamps = new HashMap<Integer, HybridTimestamp>();
        for (int catalogVersion = earliestCatalogVersion; catalogVersion <= latestCatalogVersion; ++catalogVersion) {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            Iterator iterator = existingZoneIds.iterator();
            while (iterator.hasNext()) {
                Integer zoneId = (Integer)iterator.next();
                if (catalog.zone(zoneId.intValue()) != null) continue;
                zoneDeletionTimestamps.put(zoneId, HybridTimestamp.hybridTimestamp((long)catalog.time()));
                iterator.remove();
            }
            for (CatalogZoneDescriptor zone : catalog.zones()) {
                existingZoneIds.add(zone.id());
            }
        }
        return zoneDeletionTimestamps;
    }

    static HybridTimestamp ceilTime(NavigableMap<HybridTimestamp, CatalogZoneDescriptor> zoneDescriptors, HybridTimestamp timestamp, HybridTimestamp latestTimestamp) {
        HybridTimestamp ceilingKey = zoneDescriptors.ceilingKey(timestamp.tick());
        return ceilingKey == null ? latestTimestamp : HybridTimestamp.hybridTimestamp((long)(ceilingKey.longValue() - 1L));
    }

    static HybridTimestamp findProperTimestampForAssignments(Map<Integer, Assignments> assignments, NavigableMap<HybridTimestamp, CatalogZoneDescriptor> zoneDescriptors, HybridTimestamp latestTimestamp) {
        long timestamp = assignments.values().stream().mapToLong(Assignments::timestamp).max().orElse(zoneDescriptors.firstEntry().getKey().longValue());
        return RebalanceMinimumRequiredTimeProviderImpl.ceilTime(zoneDescriptors, HybridTimestamp.hybridTimestamp((long)timestamp), latestTimestamp);
    }

    private Map<Integer, Integer> tableIdToZoneIdMap(int earliestCatalogVersion, int latestCatalogVersion) {
        HashMap<Integer, Integer> tableIdToZoneIdMap = new HashMap<Integer, Integer>();
        for (int catalogVersion = earliestCatalogVersion; catalogVersion <= latestCatalogVersion; ++catalogVersion) {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            for (CatalogTableDescriptor table : catalog.tables()) {
                tableIdToZoneIdMap.putIfAbsent(table.id(), table.zoneId());
            }
        }
        return tableIdToZoneIdMap;
    }

    private Map<Integer, Map<Integer, Assignments>> readPendingAssignments(long appliedRevision) {
        return this.readAssignments(RebalanceUtil.PENDING_ASSIGNMENTS_QUEUE_PREFIX_BYTES, appliedRevision, bytes -> AssignmentsQueue.fromBytes((byte[])bytes).poll());
    }

    private Map<Integer, Map<Integer, Assignments>> readAssignments(byte[] prefix, long appliedRevision) {
        return this.readAssignments(prefix, appliedRevision, Assignments::fromBytes);
    }

    Map<Integer, Map<Integer, Assignments>> readAssignments(byte[] prefix, long appliedRevision, Function<byte[], Assignments> deserializer) {
        HashMap<Integer, Map<Integer, Assignments>> assignments = new HashMap<Integer, Map<Integer, Assignments>>();
        try (Cursor<Entry> entries = this.readLocallyByPrefix(prefix, appliedRevision);){
            for (Entry entry : entries) {
                if (entry.empty() || entry.tombstone()) continue;
                TablePartitionId tablePartitionId = RebalanceUtil.extractTablePartitionId(entry.key(), prefix);
                int tableId = tablePartitionId.tableId();
                int partitionId = tablePartitionId.partitionId();
                assignments.computeIfAbsent(tableId, id -> new HashMap()).put(partitionId, deserializer.apply(entry.value()));
            }
        }
        return assignments;
    }

    Map<Integer, HybridTimestamp> readPendingChangeTriggerTimestamps(byte[] prefix, long appliedRevision) {
        HashMap<Integer, HybridTimestamp> timestamps = new HashMap<Integer, HybridTimestamp>();
        try (Cursor<Entry> entries = this.readLocallyByPrefix(prefix, appliedRevision);){
            for (Entry entry : entries) {
                if (entry.empty() || entry.tombstone()) continue;
                int tableId = RebalanceUtil.extractTablePartitionId(entry.key(), prefix).tableId();
                byte[] valueBytes = entry.value();
                long timestampLong = ByteUtils.bytesToLongKeepingOrder((byte[])valueBytes);
                HybridTimestamp timestamp = HybridTimestamp.hybridTimestamp((long)timestampLong);
                timestamps.compute(tableId, (k, prev) -> prev == null ? timestamp : RebalanceMinimumRequiredTimeProviderImpl.min(prev, timestamp));
            }
        }
        return timestamps;
    }

    private static HybridTimestamp min(HybridTimestamp a, HybridTimestamp b) {
        return a.compareTo(b) < 0 ? a : b;
    }

    private Cursor<Entry> readLocallyByPrefix(byte[] prefix, long revision) {
        return this.metaStorageManager.prefixLocally(new ByteArray(prefix), revision);
    }
}

