/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.cluster;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.IgniteCluster;
import org.apache.ignite.network.NetworkAddress;

public class ClientClusterGetNodesRequest {
    public static CompletableFuture<ResponseWriter> process(IgniteCluster cluster) {
        return cluster.nodesAsync().thenApply(nodes -> out -> {
            out.packInt(nodes.size());
            for (ClusterNode node : nodes) {
                ClientClusterGetNodesRequest.packClusterNode(node, out);
            }
        });
    }

    public static void packClusterNode(ClusterNode clusterNode, ClientMessagePacker out) {
        out.packInt(4);
        out.packUuid(clusterNode.id());
        out.packString(clusterNode.name());
        NetworkAddress address = clusterNode.address();
        out.packString(address.host());
        out.packInt(address.port());
    }
}

