/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.JdbcConnectionContext;
import org.apache.ignite.client.handler.JdbcHandlerBase;
import org.apache.ignite.client.handler.requests.jdbc.JdbcMetadataCatalog;
import org.apache.ignite.client.handler.requests.jdbc.JdbcQueryCursor;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.jdbc.proto.JdbcQueryEventHandler;
import org.apache.ignite.internal.jdbc.proto.JdbcStatementType;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchPreparedStmntRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcConnectResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcFinishTxResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaPrimaryKeysResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaSchemasRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaSchemasResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaTablesRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaTablesResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryCancelResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQuerySingleResult;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.SqlProperties;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.jetbrains.annotations.Nullable;

public class JdbcQueryEventHandlerImpl
extends JdbcHandlerBase
implements JdbcQueryEventHandler {
    public static final Set<SqlQueryType> UPDATE_STATEMENT_QUERIES = EnumSet.of(SqlQueryType.DML, SqlQueryType.DDL, SqlQueryType.KILL);
    private final QueryProcessor processor;
    private final JdbcMetadataCatalog meta;
    private final TxManager txManager;

    public JdbcQueryEventHandlerImpl(QueryProcessor processor, JdbcMetadataCatalog meta, ClientResourceRegistry resources, TxManager txManager) {
        super(resources);
        this.processor = processor;
        this.meta = meta;
        this.txManager = txManager;
    }

    public CompletableFuture<JdbcConnectResult> connect(ZoneId timeZoneId, String username) {
        try {
            JdbcConnectionContext connectionContext = new JdbcConnectionContext(this.txManager, timeZoneId, username);
            long connectionId = this.resources.put(new ClientResource(connectionContext, connectionContext::close));
            return CompletableFuture.completedFuture(new JdbcConnectResult(connectionId));
        }
        catch (IgniteInternalCheckedException exception) {
            String msg = JdbcQueryEventHandlerImpl.getErrorMessage(exception);
            return CompletableFuture.completedFuture(new JdbcConnectResult(1, "Unable to connect: " + msg));
        }
    }

    public CompletableFuture<? extends Response> queryAsync(long connectionId, JdbcQueryExecuteRequest req) {
        JdbcConnectionContext connectionContext;
        if (req.pageSize() <= 0) {
            return CompletableFuture.completedFuture(new JdbcQuerySingleResult(1, "Invalid fetch size [fetchSize=" + req.pageSize() + "]"));
        }
        try {
            connectionContext = this.resources.get(connectionId).get(JdbcConnectionContext.class);
        }
        catch (IgniteInternalCheckedException exception) {
            return CompletableFuture.completedFuture(new JdbcQuerySingleResult(1, "Connection is broken"));
        }
        long correlationToken = req.correlationToken();
        CancellationToken token = connectionContext.registerExecution(correlationToken);
        HybridTimestampTracker timeTracker = Objects.requireNonNull(req.timestampTracker());
        JdbcStatementType reqStmtType = req.getStmtType();
        String defaultSchemaName = req.schemaName();
        boolean multiStatement = req.multiStatement();
        ZoneId timeZoneId = connectionContext.timeZoneId();
        long timeoutMillis = req.queryTimeoutMillis();
        String userName = connectionContext.userName();
        InternalTransaction tx = req.autoCommit() ? null : connectionContext.getOrStartTransaction(timeTracker);
        SqlProperties properties = JdbcQueryEventHandlerImpl.createProperties(reqStmtType, defaultSchemaName, multiStatement, timeZoneId, timeoutMillis, userName);
        CompletableFuture result = this.processor.queryAsync(properties, timeTracker, tx, token, req.sqlQuery(), req.arguments() == null ? ArrayUtils.OBJECT_EMPTY_ARRAY : req.arguments());
        this.doWhenAllCursorsComplete(result, () -> connectionContext.deregisterExecution(correlationToken));
        return ((CompletableFuture)result.thenCompose(cursor -> this.createJdbcResult(new JdbcQueryCursor<InternalSqlRow>(req.maxRows(), (AsyncSqlCursor<InternalSqlRow>)cursor), req.pageSize()))).exceptionally(t -> this.createErrorResult("Exception while executing query.", (Throwable)t, null));
    }

    private static SqlProperties createProperties(JdbcStatementType stmtType, String defaultSchemaName, boolean multiStatement, ZoneId timeZoneId, long queryTimeoutMillis, @Nullable String userName) {
        Set allowedTypes;
        switch (stmtType) {
            case ANY_STATEMENT_TYPE: {
                allowedTypes = multiStatement ? SqlQueryType.ALL : SqlQueryType.SINGLE_STMT_TYPES;
                break;
            }
            case SELECT_STATEMENT_TYPE: {
                allowedTypes = SELECT_STATEMENT_QUERIES;
                break;
            }
            case UPDATE_STATEMENT_TYPE: {
                allowedTypes = UPDATE_STATEMENT_QUERIES;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected jdbc statement type: " + String.valueOf(stmtType)));
            }
        }
        String schemaNameInCanonicalForm = IgniteNameUtils.parseIdentifier((String)defaultSchemaName);
        return new SqlProperties().allowedQueryTypes(allowedTypes).timeZoneId(timeZoneId).defaultSchema(schemaNameInCanonicalForm).queryTimeout(queryTimeoutMillis).userName(userName).allowMultiStatement(multiStatement);
    }

    public CompletableFuture<JdbcBatchExecuteResult> batchAsync(long connectionId, JdbcBatchExecuteRequest req) {
        JdbcConnectionContext connectionContext;
        try {
            connectionContext = this.resources.get(connectionId).get(JdbcConnectionContext.class);
        }
        catch (IgniteInternalCheckedException exception) {
            return CompletableFuture.completedFuture(new JdbcBatchExecuteResult(1, "Connection is broken"));
        }
        HybridTimestampTracker timeTracker = Objects.requireNonNull(req.timestampTracker());
        InternalTransaction tx = req.autoCommit() ? null : connectionContext.getOrStartTransaction(timeTracker);
        long correlationToken = req.correlationToken();
        CancellationToken token = connectionContext.registerExecution(correlationToken);
        String defaultSchemaName = req.schemaName();
        List queries = req.queries();
        IntArrayList counters = new IntArrayList(req.queries().size());
        CompletionStage<Object> tail = CompletableFuture.completedFuture(counters);
        long queryTimeoutMillis = req.queryTimeoutMillis();
        for (String query : queries) {
            tail = tail.thenCompose(list -> this.executeAndCollectUpdateCount(connectionContext, defaultSchemaName, timeTracker, tx, token, query, ArrayUtils.OBJECT_EMPTY_ARRAY, queryTimeoutMillis, (IntArrayList)list));
        }
        return tail.handle((ignored, t) -> {
            connectionContext.deregisterExecution(correlationToken);
            if (t != null) {
                return JdbcQueryEventHandlerImpl.handleBatchException(t, (String)queries.get(counters.size()), counters.toIntArray());
            }
            return new JdbcBatchExecuteResult(counters.toIntArray());
        });
    }

    public CompletableFuture<JdbcBatchExecuteResult> batchPrepStatementAsync(long connectionId, JdbcBatchPreparedStmntRequest req) {
        InternalTransaction tx;
        JdbcConnectionContext connectionContext;
        try {
            connectionContext = this.resources.get(connectionId).get(JdbcConnectionContext.class);
        }
        catch (IgniteInternalCheckedException exception) {
            return CompletableFuture.completedFuture(new JdbcBatchExecuteResult(1, "Connection is broken"));
        }
        HybridTimestampTracker timeTracker = Objects.requireNonNull(req.timestampTracker());
        InternalTransaction internalTransaction = tx = req.autoCommit() ? null : connectionContext.getOrStartTransaction(timeTracker);
        assert (req.autoCommit() || tx != null);
        long correlationToken = req.correlationToken();
        CancellationToken token = connectionContext.registerExecution(correlationToken);
        List argList = req.getArgs();
        String defaultSchemaName = req.schemaName();
        IntArrayList counters = new IntArrayList(req.getArgs().size());
        CompletionStage<Object> tail = CompletableFuture.completedFuture(counters);
        long timeoutMillis = req.queryTimeoutMillis();
        for (Object[] args : argList) {
            tail = tail.thenCompose(list -> this.executeAndCollectUpdateCount(connectionContext, defaultSchemaName, timeTracker, tx, token, req.getQuery(), args, timeoutMillis, (IntArrayList)list));
        }
        return tail.handle((ignored, t) -> {
            connectionContext.deregisterExecution(correlationToken);
            if (t != null) {
                return JdbcQueryEventHandlerImpl.handleBatchException(t, req.getQuery(), counters.toIntArray());
            }
            return new JdbcBatchExecuteResult(counters.toIntArray());
        });
    }

    private CompletableFuture<IntArrayList> executeAndCollectUpdateCount(JdbcConnectionContext context, String defaultSchemaName, HybridTimestampTracker tracker, @Nullable InternalTransaction tx, CancellationToken token, String sql, Object[] arg, long timeoutMillis, IntArrayList resultUpdateCounters) {
        if (!context.valid()) {
            return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Client.CONNECTION_ERR, "Connection is closed"));
        }
        SqlProperties properties = JdbcQueryEventHandlerImpl.createProperties(JdbcStatementType.UPDATE_STATEMENT_TYPE, defaultSchemaName, false, context.timeZoneId(), timeoutMillis, context.userName());
        CompletableFuture result = this.processor.queryAsync(properties, tracker, tx, token, sql, arg == null ? ArrayUtils.OBJECT_EMPTY_ARRAY : arg);
        return result.thenCompose(cursor -> cursor.requestNextAsync(1).thenApply(batch -> {
            int updateCounter = JdbcQueryEventHandlerImpl.handleBatchResult(cursor.queryType(), (AsyncCursor.BatchedResult<InternalSqlRow>)batch);
            resultUpdateCounters.add(updateCounter);
            return resultUpdateCounters;
        }));
    }

    private static int handleBatchResult(SqlQueryType type, AsyncCursor.BatchedResult<InternalSqlRow> result) {
        switch (type) {
            case DDL: 
            case KILL: {
                return -2;
            }
            case DML: {
                Long updateCounts = (Long)((InternalSqlRow)result.items().get(0)).get(0);
                assert (updateCounts != null) : "Invalid DML result";
                return updateCounts > Integer.MAX_VALUE ? -2 : updateCounts.intValue();
            }
        }
        throw new IllegalStateException("Unexpected query type: " + String.valueOf(type));
    }

    private static JdbcBatchExecuteResult handleBatchException(Throwable e, String query, int[] counters) {
        String msg = JdbcQueryEventHandlerImpl.getErrorMessage(e);
        Object error = e instanceof ClassCastException ? "Unexpected result. Not an upsert statement? [query=" + query + "] Error message:" + msg : msg;
        return new JdbcBatchExecuteResult(1, 1, (String)error, counters);
    }

    public CompletableFuture<JdbcMetaTablesResult> tablesMetaAsync(JdbcMetaTablesRequest req) {
        return this.meta.getTablesMeta(req.schemaName(), req.tableName(), req.tableTypes()).thenApply(JdbcMetaTablesResult::new);
    }

    public CompletableFuture<JdbcMetaColumnsResult> columnsMetaAsync(JdbcMetaColumnsRequest req) {
        return this.meta.getColumnsMeta(req.schemaName(), req.tableName(), req.columnName()).thenApply(JdbcMetaColumnsResult::new);
    }

    public CompletableFuture<JdbcMetaSchemasResult> schemasMetaAsync(JdbcMetaSchemasRequest req) {
        return this.meta.getSchemasMeta(req.schemaName()).thenApply(JdbcMetaSchemasResult::new);
    }

    public CompletableFuture<JdbcMetaPrimaryKeysResult> primaryKeysMetaAsync(JdbcMetaPrimaryKeysRequest req) {
        return this.meta.getPrimaryKeys(req.schemaName(), req.tableName()).thenApply(JdbcMetaPrimaryKeysResult::new);
    }

    public CompletableFuture<JdbcFinishTxResult> finishTxAsync(long connectionId, boolean commit) {
        JdbcConnectionContext connectionContext;
        try {
            connectionContext = this.resources.get(connectionId).get(JdbcConnectionContext.class);
        }
        catch (IgniteInternalCheckedException exception) {
            return CompletableFuture.completedFuture(new JdbcFinishTxResult(1, "Connection is broken"));
        }
        return connectionContext.finishTransactionAsync(commit).handle((observableTime, t) -> {
            if (t != null) {
                return new JdbcFinishTxResult(1, t.getMessage());
            }
            return new JdbcFinishTxResult(observableTime);
        });
    }

    public CompletableFuture<JdbcQueryCancelResult> cancelAsync(long connectionId, long correlationToken) {
        JdbcConnectionContext connectionContext;
        try {
            connectionContext = this.resources.get(connectionId).get(JdbcConnectionContext.class);
        }
        catch (IgniteInternalCheckedException exception) {
            return CompletableFuture.completedFuture(new JdbcQueryCancelResult(1, "Connection is broken"));
        }
        return connectionContext.cancelExecution(correlationToken).handle((ignored, t) -> {
            if (t != null) {
                return new JdbcQueryCancelResult(1, t.getMessage());
            }
            return new JdbcQueryCancelResult();
        });
    }

    private void doWhenAllCursorsComplete(CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorFuture, final Runnable action) {
        final ArrayList dependency = new ArrayList();
        Function cursorChainTraverser = new Function<AsyncSqlCursor<?>, CompletableFuture<AsyncSqlCursor<?>>>(){

            @Override
            public CompletableFuture<AsyncSqlCursor<?>> apply(AsyncSqlCursor<?> cursor) {
                dependency.add(cursor.onClose());
                if (cursor.hasNextResult()) {
                    return cursor.nextResult().thenCompose((Function)this);
                }
                return ((CompletableFuture)CompletableFutures.allOf((Collection)dependency).thenRun(action)).thenApply(ignored -> cursor);
            }
        };
        ((CompletableFuture)cursorFuture.thenCompose(cursorChainTraverser)).exceptionally(ex -> {
            action.run();
            return null;
        });
    }
}

