/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Iif;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.Statements;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite.internal.partitiondistribution.PartitionDistributionUtils;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;

public class RebalanceUtilEx {
    public static CompletableFuture<Void> startPeerRemoval(TablePartitionId partId, Assignment peerAssignment, MetaStorageManager metaStorageMgr, long assignmentsTimestamp) {
        ByteArray key = RebalanceUtil.switchReduceKey((TablePartitionId)partId);
        return ((CompletableFuture)metaStorageMgr.get(key).thenCompose(retrievedAssignmentsSwitchReduce -> {
            byte[] prevValue = retrievedAssignmentsSwitchReduce.value();
            if (prevValue != null) {
                Assignments prev = Assignments.fromBytes((byte[])prevValue);
                prev.add(peerAssignment);
                return metaStorageMgr.invoke((Condition)Conditions.revision((ByteArray)key).eq(retrievedAssignmentsSwitchReduce.revision()), Operations.put((ByteArray)key, (byte[])prev.toBytes()), Operations.noop());
            }
            Assignments newValue = Assignments.of(new HashSet(), (long)assignmentsTimestamp);
            newValue.add(peerAssignment);
            return metaStorageMgr.invoke((Condition)Conditions.notExists((ByteArray)key), Operations.put((ByteArray)key, (byte[])newValue.toBytes()), Operations.noop());
        })).thenCompose(res -> {
            if (!res.booleanValue()) {
                return RebalanceUtilEx.startPeerRemoval(partId, peerAssignment, metaStorageMgr, assignmentsTimestamp);
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    public static CompletableFuture<Void> handleReduceChanged(MetaStorageManager metaStorageMgr, Collection<String> dataNodes, int partitions, int replicas, int consensusGroupSize, TablePartitionId partId, WatchEvent event, long assignmentsTimestamp) {
        Entry entry = event.entryEvent().newEntry();
        byte[] eventData = entry.value();
        assert (eventData != null) : "Null event data for " + String.valueOf(partId);
        Assignments switchReduce = Assignments.fromBytes((byte[])eventData);
        if (switchReduce.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        Set assignments = PartitionDistributionUtils.calculateAssignmentForPartition(dataNodes, (int)partId.partitionId(), (int)partitions, (int)replicas, (int)consensusGroupSize);
        ByteArray pendingKey = RebalanceUtil.pendingPartAssignmentsQueueKey((TablePartitionId)partId);
        Set pendingAssignments = CollectionUtils.difference((Set)assignments, (Set)switchReduce.nodes());
        byte[] pendingByteArray = AssignmentsQueue.toBytes((Assignments[])new Assignments[]{Assignments.of((Set)pendingAssignments, (long)assignmentsTimestamp)});
        byte[] assignmentsByteArray = Assignments.toBytes((Set)assignments, (long)assignmentsTimestamp);
        ByteArray changeTriggerKey = RebalanceUtil.pendingChangeTriggerKey((TablePartitionId)partId);
        byte[] timestamp = ByteUtils.longToBytesKeepingOrder((long)entry.timestamp().longValue());
        CompoundCondition revisionAndTimestampDontExistOrLessThan = Conditions.or((Condition)Conditions.notExists((ByteArray)changeTriggerKey), (Condition)Conditions.value((ByteArray)changeTriggerKey).lt(timestamp));
        Iif resultingOperation = Statements.iif((Condition)Conditions.and((Condition)revisionAndTimestampDontExistOrLessThan, (Condition)Conditions.and((Condition)Conditions.notExists((ByteArray)pendingKey), (Condition)Conditions.notExists((ByteArray)RebalanceUtil.stablePartAssignmentsKey((TablePartitionId)partId)))), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)pendingKey, (byte[])pendingByteArray), Operations.put((ByteArray)RebalanceUtil.stablePartAssignmentsKey((TablePartitionId)partId), (byte[])assignmentsByteArray), Operations.put((ByteArray)changeTriggerKey, (byte[])timestamp)}).yield(), (Iif)Statements.iif((Condition)Conditions.and((Condition)revisionAndTimestampDontExistOrLessThan, (Condition)Conditions.notExists((ByteArray)pendingKey)), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)pendingKey, (byte[])pendingByteArray), Operations.put((ByteArray)changeTriggerKey, (byte[])timestamp)}).yield(), (Update)Operations.ops((Operation[])new Operation[0]).yield()));
        return metaStorageMgr.invoke(resultingOperation).thenApply(unused -> null);
    }
}

