/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequest;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequestType;
import org.apache.ignite.internal.table.distributed.disaster.GroupUpdateRequestHandler;
import org.apache.ignite.internal.tostring.S;

class GroupUpdateRequest
implements DisasterRecoveryRequest {
    private final UUID operationId;
    private final int catalogVersion;
    private final int zoneId;
    private final boolean colocationEnabled;
    private final Map<Integer, Set<Integer>> partitionIds;
    private final boolean manualUpdate;

    private GroupUpdateRequest(UUID operationId, int catalogVersion, int zoneId, Map<Integer, Set<Integer>> partitionIds, boolean manualUpdate, boolean colocationEnabled) {
        this.operationId = operationId;
        this.catalogVersion = catalogVersion;
        this.zoneId = zoneId;
        this.partitionIds = Map.copyOf(partitionIds);
        this.manualUpdate = manualUpdate;
        this.colocationEnabled = colocationEnabled;
    }

    @Override
    public UUID operationId() {
        return this.operationId;
    }

    @Override
    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public DisasterRecoveryRequestType type() {
        return DisasterRecoveryRequestType.SINGLE_NODE;
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    public Map<Integer, Set<Integer>> partitionIds() {
        return this.partitionIds;
    }

    public boolean manualUpdate() {
        return this.manualUpdate;
    }

    boolean colocationEnabled() {
        return this.colocationEnabled;
    }

    public static GroupUpdateRequest create(UUID operationId, int catalogVersion, int zoneId, Map<Integer, Set<Integer>> partitionIds, boolean manualUpdate, boolean colocationEnabled) {
        return new GroupUpdateRequest(operationId, catalogVersion, zoneId, partitionIds, manualUpdate, colocationEnabled);
    }

    @Override
    public CompletableFuture<Void> handle(DisasterRecoveryManager disasterRecoveryManager, long msRevision, HybridTimestamp msTimestamp) {
        return GroupUpdateRequestHandler.handler(this).handle(disasterRecoveryManager, msRevision, msTimestamp);
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

