/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.impl.Parseable;
import com.typesafe.config.parser.ConfigDocument;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.jetbrains.annotations.Nullable;

public class ConfigurationDuplicatesValidator {
    public static Collection<ValidationIssue> validate(String cfg) {
        Object root = ConfigurationDuplicatesValidator.getConfigRoot(cfg);
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        queue.add(new Node(root, null, null));
        HashSet<String> paths = new HashSet<String>();
        HashSet<ValidationIssue> issues = new HashSet<ValidationIssue>();
        while (!queue.isEmpty()) {
            Node currentNode = (Node)queue.poll();
            List<Object> nodeChildren = ConfigurationDuplicatesValidator.getChildrenOrEmpty(currentNode.configNode);
            if (nodeChildren.isEmpty()) continue;
            Path currentPath = ConfigNodePath.path(currentNode.basePath, nodeChildren, currentNode.indexInArray);
            if (currentPath != null) {
                String pathString = currentPath.toString();
                if (!paths.add(pathString)) {
                    issues.add(new ValidationIssue(pathString, "Duplicated key"));
                }
            } else {
                currentPath = currentNode.basePath;
            }
            int index = 0;
            for (Object child : nodeChildren) {
                if (!ConfigNodeComplexValue.isInstance(child) && !ConfigNodeField.isInstance(child)) continue;
                Integer indexInArray = ConfigNodeArray.isInstance(currentNode.configNode) ? Integer.valueOf(index) : null;
                queue.add(new Node(child, currentPath, indexInArray));
                ++index;
            }
        }
        return issues;
    }

    private static Object getConfigRoot(String cfg) {
        ConfigDocument configDocument = Parseable.newString((String)cfg, (ConfigParseOptions)ConfigParseOptions.defaults()).parseConfigDocument();
        assert (SimpleConfigDocument.isInstance(configDocument));
        Object root = SimpleConfigDocument.root(configDocument);
        assert (ConfigNodeComplexValue.isInstance(root));
        return root;
    }

    private static List<Object> getChildrenOrEmpty(Object configNode) {
        if (ConfigNodeComplexValue.isInstance(configNode)) {
            return ConfigNodeComplexValue.children(configNode);
        }
        if (ConfigNodeField.isInstance(configNode)) {
            return ConfigNodeField.children(configNode);
        }
        return List.of();
    }

    private static class Node {
        private final Object configNode;
        @Nullable
        private final Path basePath;
        @Nullable
        private final Integer indexInArray;

        private Node(Object configNode, @Nullable Path basePath, @Nullable Integer indexInArray) {
            this.configNode = configNode;
            this.basePath = basePath;
            this.indexInArray = indexInArray;
        }
    }

    private static class Path {
        @Nullable
        private final Path basePath;
        private final String path;

        private Path(@Nullable Path basePath, String path) {
            this.basePath = basePath;
            this.path = path;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.appendTo(builder);
            return builder.toString();
        }

        private void appendTo(StringBuilder builder) {
            if (this.basePath != null) {
                this.basePath.appendTo(builder);
                builder.append('.');
            }
            builder.append(this.path);
        }
    }

    private static class ConfigNodePath {
        private static final Class<?> CLASS;
        private static final Class<?> PATH_CLASS;
        private static final Field PATH_FIELD;
        private static final Method PATH_RENDER_METHOD;

        private ConfigNodePath() {
        }

        private static boolean isInstance(Object configNode) {
            return CLASS.isInstance(configNode);
        }

        @Nullable
        private static Path path(@Nullable Path basePath, List<Object> children, @Nullable Integer index) {
            if (index != null) {
                return new Path(basePath, "[" + index + "]");
            }
            Object pathNode = null;
            for (Object child : children) {
                if (!ConfigNodePath.isInstance(child)) continue;
                pathNode = child;
            }
            if (pathNode == null) {
                return null;
            }
            try {
                Object path = PATH_FIELD.get(pathNode);
                return new Path(basePath, PATH_RENDER_METHOD.invoke(path, new Object[0]).toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                CLASS = Class.forName("com.typesafe.config.impl.ConfigNodePath");
                PATH_CLASS = Class.forName("com.typesafe.config.impl.Path");
                PATH_FIELD = CLASS.getDeclaredField("path");
                PATH_FIELD.setAccessible(true);
                PATH_RENDER_METHOD = PATH_CLASS.getDeclaredMethod("render", new Class[0]);
                PATH_RENDER_METHOD.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ConfigNodeComplexValue {
        private static final Class<?> CLASS;
        private static final Field CHILDREN_FIELD;

        private ConfigNodeComplexValue() {
        }

        private static boolean isInstance(Object configNode) {
            return CLASS.isInstance(configNode);
        }

        private static List<Object> children(Object configNodeComplexValue) {
            try {
                return (List)CHILDREN_FIELD.get(configNodeComplexValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                CLASS = Class.forName("com.typesafe.config.impl.ConfigNodeComplexValue");
                CHILDREN_FIELD = CLASS.getDeclaredField("children");
                CHILDREN_FIELD.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ConfigNodeField {
        private static final Class<?> CLASS;
        private static final Field CHILDREN_FIELD;

        private ConfigNodeField() {
        }

        private static boolean isInstance(Object configNode) {
            return CLASS.isInstance(configNode);
        }

        private static List<Object> children(Object configNode) {
            try {
                return (List)CHILDREN_FIELD.get(configNode);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                CLASS = Class.forName("com.typesafe.config.impl.ConfigNodeField");
                CHILDREN_FIELD = CLASS.getDeclaredField("children");
                CHILDREN_FIELD.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ConfigNodeArray {
        private static final Class<?> CLASS;

        private ConfigNodeArray() {
        }

        private static boolean isInstance(Object configNode) {
            return CLASS.isInstance(configNode);
        }

        static {
            try {
                CLASS = Class.forName("com.typesafe.config.impl.ConfigNodeArray");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SimpleConfigDocument {
        private static final Class<?> CLASS;
        private static final Field NODE_TREE_FIELD;

        private SimpleConfigDocument() {
        }

        private static boolean isInstance(Object configDocument) {
            return CLASS.isInstance(configDocument);
        }

        private static Object root(Object simpleConfigDocument) {
            try {
                return NODE_TREE_FIELD.get(simpleConfigDocument);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                CLASS = Class.forName("com.typesafe.config.impl.SimpleConfigDocument");
                NODE_TREE_FIELD = CLASS.getDeclaredField("configNodeTree");
                NODE_TREE_FIELD.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

