/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataRequestBuilder;

class SnapshotMvDataRequestDeserializer
implements MessageDeserializer<SnapshotMvDataRequest> {
    private final SnapshotMvDataRequestBuilder msg;

    SnapshotMvDataRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotMvDataRequest();
    }

    public Class<SnapshotMvDataRequest> klass() {
        return SnapshotMvDataRequest.class;
    }

    public SnapshotMvDataRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("batchSizeHint");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.batchSizeHint(tmp);
                reader.incrementState();
            }
            case 1: {
                UUID tmp = reader.readUuid("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.id(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotMvDataRequest.class);
    }
}

