/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSelectCount
extends AbstractRelNode
implements IgniteRel {
    private static final String REL_TYPE_NAME = "SelectCount";
    private final RelOptTable table;
    private final List<RexNode> expressions;

    public IgniteSelectCount(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, List<RexNode> expressions) {
        super(cluster, traits);
        this.table = table;
        this.expressions = expressions;
    }

    public RelDataType deriveRowType() {
        return RexUtil.createStructType((RelDataTypeFactory)Commons.typeFactory(this.getCluster()), this.expressions);
    }

    public RelOptTable getTable() {
        return this.table;
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public RelNode accept(RexShuttle shuttle) {
        List newExpressions = shuttle.apply(this.expressions);
        if (newExpressions == this.expressions) {
            return this;
        }
        return new IgniteSelectCount(this.getCluster(), this.getTraitSet(), this.table, newExpressions);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        assert (inputs.isEmpty()) : inputs;
        return new IgniteSelectCount(cluster, this.getTraitSet(), this.table, this.expressions);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", (Object)this.table.getQualifiedName()).itemIf("expressions", this.expressions, this.expressions.size() > 1);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    public List<RexNode> expressions() {
        return this.expressions;
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        return costFactory.makeTinyCost();
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        RelDataType rowType = typeFactory.builder().add("$COUNT_ALL", typeFactory.createSqlType(SqlTypeName.BIGINT)).build();
        return writer.addTable(this.table).addProjection(this.expressions, rowType);
    }
}

