/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.IntPredicate;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.ignite.internal.sql.engine.externalize.RelInputEx;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.rel.AbstractIgniteJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.Commons;

public class IgniteMergeJoin
extends AbstractIgniteJoin {
    private static final String REL_TYPE_NAME = "MergeJoin";
    private final RelCollation leftCollation;
    private final RelCollation rightCollation;

    public IgniteMergeJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        this(cluster, traitSet, left, right, condition, variablesSet, joinType, left.getTraitSet().getCollation(), right.getTraitSet().getCollation());
    }

    public IgniteMergeJoin(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), (RelNode)input.getInputs().get(0), (RelNode)input.getInputs().get(1), input.getExpression("condition"), Set.copyOf(Commons.transform(input.getIntegerList("variablesSet"), CorrelationId::new)), (JoinRelType)input.getEnum("joinType", JoinRelType.class), ((RelInputEx)input).getCollation("leftCollation"), ((RelInputEx)input).getCollation("rightCollation"));
    }

    private IgniteMergeJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, RelCollation leftCollation, RelCollation rightCollation) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
        this.leftCollation = leftCollation;
        this.rightCollation = rightCollation;
    }

    public Join copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new IgniteMergeJoin(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType, left.getTraitSet().getCollation(), right.getTraitSet().getCollation());
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteMergeJoin(cluster, this.getTraitSet(), (RelNode)inputs.get(0), (RelNode)inputs.get(1), this.getCondition(), this.getVariablesSet(), this.getJoinType(), this.leftCollation, this.rightCollation);
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        RelCollation leftCollation = TraitUtils.collation(left);
        RelCollation rightCollation = TraitUtils.collation(right);
        if (RelCollations.containsOrderless((RelCollation)leftCollation, (List)this.joinInfo.leftKeys)) {
            rightCollation = IgniteMergeJoin.buildDesiredCollation(this.joinInfo, leftCollation, true);
        } else if (RelCollations.containsOrderless((RelCollation)rightCollation, (List)this.joinInfo.rightKeys)) {
            leftCollation = IgniteMergeJoin.buildDesiredCollation(this.joinInfo, rightCollation, false);
        } else {
            leftCollation = RelCollations.of((ImmutableIntList)this.joinInfo.leftKeys);
            rightCollation = RelCollations.of((ImmutableIntList)this.joinInfo.rightKeys);
        }
        RelCollation desiredCollation = leftCollation;
        if (this.joinType == JoinRelType.RIGHT || this.joinType == JoinRelType.FULL) {
            desiredCollation = RelCollations.EMPTY;
        }
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)desiredCollation), List.of(left.replace((RelTrait)leftCollation), right.replace((RelTrait)rightCollation))));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet required, List<RelTraitSet> inputTraits) {
        RelCollation rightCollation;
        RelCollation leftCollation;
        RelCollation nodeCollation;
        RelCollation collation = TraitUtils.collation(required);
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        if (this.joinType == JoinRelType.FULL) {
            return this.defaultCollationPair(required, left, right);
        }
        int leftInputFieldCount = this.left.getRowType().getFieldCount();
        List reqKeys = RelCollations.ordinals((RelCollation)collation);
        List leftKeys = this.joinInfo.leftKeys.toIntegerList();
        List rightKeys = this.joinInfo.rightKeys.incr(leftInputFieldCount).toIntegerList();
        ImmutableBitSet reqKeySet = ImmutableBitSet.of((Iterable)reqKeys);
        ImmutableBitSet leftKeySet = ImmutableBitSet.of((ImmutableIntList)this.joinInfo.leftKeys);
        ImmutableBitSet rightKeySet = ImmutableBitSet.of((Iterable)rightKeys);
        if (reqKeySet.equals((Object)leftKeySet)) {
            if (this.joinType == JoinRelType.RIGHT) {
                return this.defaultCollationPair(required, left, right);
            }
            nodeCollation = collation;
            leftCollation = collation;
            rightCollation = IgniteMergeJoin.buildDesiredCollation(this.joinInfo, leftCollation, true);
        } else if (RelCollations.containsOrderless((List)leftKeys, (RelCollation)collation)) {
            if (this.joinType == JoinRelType.RIGHT) {
                return this.defaultCollationPair(required, left, right);
            }
            nodeCollation = collation;
            leftCollation = IgniteMergeJoin.extendCollation(collation, leftKeys);
            rightCollation = IgniteMergeJoin.buildDesiredCollation(this.joinInfo, leftCollation, true);
        } else if (RelCollations.containsOrderless((RelCollation)collation, (List)leftKeys) && reqKeys.stream().allMatch(i -> i < leftInputFieldCount)) {
            if (this.joinType == JoinRelType.RIGHT) {
                return this.defaultCollationPair(required, left, right);
            }
            nodeCollation = collation;
            leftCollation = collation;
            rightCollation = IgniteMergeJoin.buildDesiredCollation(this.joinInfo, leftCollation, true);
        } else if (reqKeySet.equals((Object)rightKeySet)) {
            if (this.joinType == JoinRelType.LEFT) {
                return this.defaultCollationPair(required, left, right);
            }
            nodeCollation = collation;
            rightCollation = RelCollations.shift((RelCollation)collation, (int)(-leftInputFieldCount));
            leftCollation = IgniteMergeJoin.buildDesiredCollation(this.joinInfo, rightCollation, false);
        } else if (RelCollations.containsOrderless((List)rightKeys, (RelCollation)collation)) {
            if (this.joinType == JoinRelType.LEFT) {
                return this.defaultCollationPair(required, left, right);
            }
            nodeCollation = collation;
            rightCollation = RelCollations.shift((RelCollation)IgniteMergeJoin.extendCollation(collation, rightKeys), (int)(-leftInputFieldCount));
            leftCollation = IgniteMergeJoin.buildDesiredCollation(this.joinInfo, rightCollation, false);
        } else {
            return this.defaultCollationPair(required, left, right);
        }
        return Pair.of((Object)required.replace((RelTrait)nodeCollation), List.of(left.replace((RelTrait)leftCollation), right.replace((RelTrait)rightCollation)));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double leftCount = mq.getRowCount(this.getLeft());
        if (Double.isInfinite(leftCount)) {
            return costFactory.makeInfiniteCost();
        }
        double rightCount = mq.getRowCount(this.getRight());
        if (Double.isInfinite(rightCount)) {
            return costFactory.makeInfiniteCost();
        }
        double rows = leftCount + rightCount;
        return costFactory.makeCost(rows, rows * 4.0, 0.0);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("leftCollation", (Object)this.leftCollation).item("rightCollation", (Object)this.rightCollation);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    public RelCollation leftCollation() {
        return this.leftCollation;
    }

    public RelCollation rightCollation() {
        return this.rightCollation;
    }

    private Pair<RelTraitSet, List<RelTraitSet>> defaultCollationPair(RelTraitSet nodeTraits, RelTraitSet leftInputTraits, RelTraitSet rightInputTraits) {
        return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), List.of(leftInputTraits.replace((RelTrait)RelCollations.of((ImmutableIntList)this.joinInfo.leftKeys)), rightInputTraits.replace((RelTrait)RelCollations.of((ImmutableIntList)this.joinInfo.rightKeys))));
    }

    private static RelCollation extendCollation(RelCollation collation, List<Integer> keys) {
        ArrayList fieldsForNewCollation = new ArrayList(keys.size());
        fieldsForNewCollation.addAll(collation.getFieldCollations());
        ImmutableBitSet keysBitset = ImmutableBitSet.of(keys);
        ImmutableBitSet colKeysBitset = ImmutableBitSet.of((ImmutableIntList)collation.getKeys());
        ImmutableBitSet exceptBitset = keysBitset.except(colKeysBitset);
        exceptBitset.forEachInt(i -> fieldsForNewCollation.add(new RelFieldCollation(i)));
        return RelCollations.of(fieldsForNewCollation);
    }

    private static RelCollation buildDesiredCollation(JoinInfo joinInfo, RelCollation collation, boolean left2Right) {
        List source = collation.getFieldCollations();
        Int2IntArrayMap collationIndex = new Int2IntArrayMap(source.size());
        for (int i = 0; i < source.size(); ++i) {
            collationIndex.put(((RelFieldCollation)source.get(i)).getFieldIndex(), i);
        }
        List conditionPairs = joinInfo.pairs();
        ArrayList<IntPair> mapping = new ArrayList<IntPair>(conditionPairs.size());
        if (left2Right) {
            for (IntPair pair : conditionPairs) {
                mapping.add(IntPair.of((int)collationIndex.get(pair.source), (int)pair.target));
            }
        } else {
            for (IntPair pair : conditionPairs) {
                mapping.add(IntPair.of((int)collationIndex.get(pair.target), (int)pair.source));
            }
        }
        mapping.sort((Comparator<IntPair>)IntPair.ORDERING);
        IntPredicate isUnique = arg_0 -> ((IntArraySet)new IntArraySet(mapping.size())).add(arg_0);
        ArrayList<RelFieldCollation> target = new ArrayList<RelFieldCollation>(mapping.size());
        for (IntPair pair : mapping) {
            if (!isUnique.test(pair.target)) continue;
            target.add(((RelFieldCollation)source.get(pair.source)).withFieldIndex(pair.target));
        }
        return RelCollations.of(target);
    }
}

