/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.ignite.internal.lang.Debuggable;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.ExecutionId;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.SharedState;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Mailbox;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.sql.engine.trait.Destination;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class Outbox<RowT>
extends AbstractNode<RowT>
implements Mailbox<RowT>,
SingleNode<RowT>,
Downstream<RowT> {
    private static final IgniteLogger LOG = Loggers.forClass(Outbox.class);
    private static final PartitionReplicationMessagesFactory TABLE_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private final long exchangeId;
    private final long targetFragmentId;
    private final ExchangeService exchange;
    private final MailboxRegistry registry;
    private final Destination<RowT> dest;
    private final Map<String, RemoteDownstream<RowT>> nodeBuffers;
    private final Deque<RowT> inBuf;
    private Queue<RewindRequest> rewindQueue;
    private int waiting;
    @Nullable
    private String currentNode;

    public Outbox(ExecutionContext<RowT> ctx, ExchangeService exchange, MailboxRegistry registry, long exchangeId, long targetFragmentId, Destination<RowT> dest) {
        super(ctx);
        this.inBuf = new ArrayDeque<RowT>(this.inBufSize);
        this.exchange = exchange;
        this.registry = registry;
        this.targetFragmentId = targetFragmentId;
        this.exchangeId = exchangeId;
        this.dest = dest;
        HashMap downstreams = new HashMap();
        for (String nodeName : dest.targets()) {
            downstreams.put(nodeName, new RemoteDownstream(nodeName, this::sendBatch));
        }
        this.nodeBuffers = Map.copyOf(downstreams);
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    public void onRequest(String nodeName, int amountOfBatches) throws Exception {
        this.checkState();
        RemoteDownstream<RowT> downstream = this.nodeBuffers.get(nodeName);
        downstream.onBatchRequested(amountOfBatches);
        if (this.waiting != -1 || !this.inBuf.isEmpty()) {
            this.flush();
        }
    }

    public void prefetch() {
        if (!this.context().description().prefetch()) {
            return;
        }
        try {
            this.checkState();
            if (this.waiting == 0) {
                this.waiting = this.inBufSize;
                this.source().request(this.waiting);
            }
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    @Override
    public void request(int rowCnt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.waiting > 0) : this.waiting;
        --this.waiting;
        if (this.currentNode == null || this.dest.targets(row).contains(this.currentNode)) {
            this.inBuf.add(row);
        }
        this.flush();
    }

    @Override
    public void end() throws Exception {
        assert (this.waiting > 0) : this.waiting;
        this.waiting = -1;
        this.flush();
    }

    @Override
    public void onError(Throwable e) {
        this.sendError(e);
        Commons.closeQuiet(this);
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        this.registry.unregister(this);
        for (String node : this.dest.targets()) {
            this.nodeBuffers.get(node).close();
        }
    }

    @Override
    public void onRegister(Downstream<RowT> downstream) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rewindInternal() {
        this.inBuf.clear();
        this.waiting = 0;
        if (this.currentNode != null) {
            this.nodeBuffers.get(this.currentNode).reset();
            return;
        }
        for (String nodeName : this.dest.targets()) {
            RemoteDownstream<RowT> downstream = this.nodeBuffers.get(nodeName);
            assert (downstream != null);
            downstream.reset();
        }
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    @TestOnly
    public void dumpState(IgniteStringBuilder writer, String indent) {
        writer.app(indent).app("class=").app(this.getClass().getSimpleName()).app(", waiting=").app(this.waiting).nl();
        String childIndent = Debuggable.childIndentation((String)indent);
        for (Map.Entry<String, RemoteDownstream<RowT>> entry : this.nodeBuffers.entrySet()) {
            writer.app(childIndent).app("class=" + entry.getValue().getClass().getSimpleName()).app(", nodeName=").app(entry.getKey()).app(", state=").app((Object)entry.getValue().state).nl();
        }
        Debuggable.dumpState((IgniteStringBuilder)writer, (String)childIndent, this.sources());
    }

    private void sendBatch(String nodeName, int batchId, boolean last, List<RowT> rows) {
        RowHandler<RowT> handler = this.context().rowHandler();
        ArrayList<BinaryTupleMessage> rows0 = new ArrayList<BinaryTupleMessage>(rows.size());
        for (RowT row : rows) {
            rows0.add(TABLE_MESSAGES_FACTORY.binaryTupleMessage().elementCount(handler.columnCount(row)).tuple(handler.toByteBuffer(row)).build());
        }
        this.exchange.sendBatch(nodeName, this.executionId(), this.targetFragmentId, this.exchangeId, batchId, last, rows0).whenComplete((ignored, ex) -> {
            if (ex == null) {
                return;
            }
            IgniteInternalException wrapperEx = (IgniteInternalException)ExceptionUtils.withCause(IgniteInternalException::new, (int)ErrorGroups.Common.INTERNAL_ERR, (String)("Unable to send batch: " + ex.getMessage()), (Throwable)ex);
            this.execute(() -> this.onError((Throwable)wrapperEx));
        });
    }

    private void sendError(Throwable original) {
        String nodeName = this.context().originatingNodeName();
        ExecutionId executionId = this.executionId();
        long fragmentId = this.fragmentId();
        this.exchange.sendError(nodeName, executionId, fragmentId, original).whenComplete((ignored, ex) -> {
            if (ex == null) {
                return;
            }
            IgniteInternalException wrapperEx = (IgniteInternalException)ExceptionUtils.withCause(IgniteInternalException::new, (int)ErrorGroups.Common.INTERNAL_ERR, (String)("Unable to send error: " + ex.getMessage()), (Throwable)ex);
            wrapperEx.addSuppressed(original);
            LOG.warn("Unable to send error to a remote node [executionId={}, fragmentId={}, targetNode={}]", new Object[]{executionId, fragmentId, nodeName, wrapperEx});
        });
    }

    private void flush() throws Exception {
        while (!this.inBuf.isEmpty()) {
            List<String> targets = this.dest.targets(this.inBuf.peek());
            ArrayList<RemoteDownstream<RowT>> buffers = new ArrayList<RemoteDownstream<RowT>>(targets.size());
            for (String target : targets) {
                RemoteDownstream<RowT> remoteDownstream = this.nodeBuffers.get(target);
                if (!remoteDownstream.ready()) {
                    return;
                }
                buffers.add(remoteDownstream);
            }
            assert (!CollectionUtils.nullOrEmpty(buffers));
            RowT row = this.inBuf.remove();
            for (RemoteDownstream remoteDownstream : buffers) {
                remoteDownstream.add(row);
            }
        }
        assert (this.inBuf.isEmpty());
        if (this.waiting == 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.waiting);
        } else if (this.waiting == -1) {
            if (this.currentNode != null) {
                this.nodeBuffers.get(this.currentNode).end();
                this.currentNode = null;
                this.processRewindQueue();
            } else {
                for (RemoteDownstream<RowT> buffer : this.nodeBuffers.values()) {
                    buffer.end();
                }
            }
        }
    }

    public void onNodeLeft(InternalClusterNode node) {
        if (node.id().equals(this.context().originatingNodeId())) {
            this.execute(this::close);
        }
    }

    public void onRewindRequest(String nodeName, SharedState state, int amountOfBatches) throws Exception {
        this.checkState();
        if (this.rewindQueue == null) {
            this.rewindQueue = new ArrayDeque<RewindRequest>(this.nodeBuffers.size());
        }
        this.rewindQueue.offer(new RewindRequest(nodeName, state, amountOfBatches));
        if (this.currentNode == null || this.currentNode.equals(nodeName)) {
            this.currentNode = null;
            this.processRewindQueue();
        }
    }

    private void processRewindQueue() throws Exception {
        assert (this.currentNode == null);
        RewindRequest rewind = this.rewindQueue.poll();
        if (rewind == null) {
            return;
        }
        this.currentNode = rewind.nodeName;
        this.context().sharedState(rewind.state);
        this.rewind();
        this.onRequest(this.currentNode, rewind.amountOfBatches);
    }

    @TestOnly
    public boolean isDone() {
        return this.waiting == -1 && this.nodeBuffers.values().stream().allMatch(RemoteDownstream::isDone);
    }

    private static final class RemoteDownstream<RowT> {
        private final String nodeName;
        private final BatchSender<RowT> sender;
        private State state = State.FILLING;
        private int lastSentBatchId = -1;
        @Nullable
        private List<RowT> curr;
        private int pendingCount;

        private RemoteDownstream(String nodeName, BatchSender<RowT> sender) {
            this.nodeName = nodeName;
            this.sender = sender;
            this.curr = new ArrayList<RowT>(256);
        }

        void reset() {
            this.state = State.FILLING;
            this.lastSentBatchId += this.pendingCount;
            this.pendingCount = 0;
            this.curr = new ArrayList<RowT>(256);
        }

        void onBatchRequested(int amountOfBatches) throws Exception {
            assert (amountOfBatches > 0) : amountOfBatches;
            this.pendingCount += amountOfBatches;
            if (this.state == State.FULL || this.state == State.LAST_BATCH) {
                this.sendBatch();
            }
        }

        boolean ready() {
            return this.state == State.FILLING;
        }

        void add(RowT row) throws Exception {
            assert (this.ready()) : this.state;
            assert (this.curr != null);
            this.curr.add(row);
            if (this.curr.size() == 256) {
                this.state = State.FULL;
                if (this.pendingCount > 0) {
                    this.sendBatch();
                }
            }
        }

        void sendBatch() throws Exception {
            assert (this.pendingCount > 0);
            assert (this.state == State.FULL || this.state == State.LAST_BATCH) : this.state;
            assert (this.curr != null);
            boolean lastBatch = this.state == State.LAST_BATCH;
            this.sender.send(this.nodeName, ++this.lastSentBatchId, lastBatch, this.curr);
            --this.pendingCount;
            if (lastBatch) {
                this.state = State.END;
                this.curr = null;
                this.lastSentBatchId += this.pendingCount;
                this.pendingCount = 0;
            } else {
                this.state = State.FILLING;
                this.curr = new ArrayList<RowT>(256);
            }
        }

        void end() throws Exception {
            assert (this.state == State.FILLING || this.state == State.FULL) : this.state;
            this.state = State.LAST_BATCH;
            if (this.pendingCount > 0) {
                this.sendBatch();
            }
        }

        void close() {
            this.curr = null;
            this.state = State.END;
        }

        @TestOnly
        boolean isDone() {
            return this.state == State.END;
        }

        static enum State {
            FILLING,
            FULL,
            LAST_BATCH,
            END;

        }

        @FunctionalInterface
        private static interface BatchSender<RowT> {
            public void send(String var1, int var2, boolean var3, List<RowT> var4) throws IgniteInternalCheckedException;
        }
    }

    private static class RewindRequest {
        final String nodeName;
        final SharedState state;
        final int amountOfBatches;

        RewindRequest(String nodeName, SharedState state, int amountOfBatches) {
            this.nodeName = nodeName;
            this.state = state;
            this.amountOfBatches = amountOfBatches;
        }
    }
}

