/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster;

import it.unimi.dsi.fastutil.ints.Int2LongFunction;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationMappingException;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.AbstractTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.AllOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.OneOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.SomeOfTarget;

class PartitionedTarget
extends AbstractTarget {
    private final boolean finalised;
    final long[] partitionsNodes;
    final long[] enlistmentConsistencyTokens;

    PartitionedTarget(boolean finalised, long[] partitionsNodes, long[] enlistmentConsistencyTokens) {
        super(PartitionedTarget.computeNodes(partitionsNodes));
        this.finalised = finalised;
        this.partitionsNodes = partitionsNodes;
        this.enlistmentConsistencyTokens = enlistmentConsistencyTokens;
    }

    @Override
    ExecutionTarget finalise() {
        if (this.finalised) {
            return this;
        }
        long[] newPartitionsNodes = new long[this.partitionsNodes.length];
        for (int partNo = 0; partNo < this.partitionsNodes.length; ++partNo) {
            newPartitionsNodes[partNo] = PartitionedTarget.pickOne(this.partitionsNodes[partNo]);
        }
        return new PartitionedTarget(true, newPartitionsNodes, this.enlistmentConsistencyTokens);
    }

    @Override
    public ExecutionTarget colocateWith(ExecutionTarget other) throws ColocationMappingException {
        assert (other instanceof AbstractTarget) : other == null ? "<null>" : other.getClass().getCanonicalName();
        return ((AbstractTarget)other).colocate(this);
    }

    @Override
    public ExecutionTarget trimTo(ExecutionTarget other) {
        assert (other instanceof AbstractTarget) : other == null ? "<null>" : other.getClass().getCanonicalName();
        if (this.finalised) {
            return this;
        }
        long[] newPartitionsNodes = new long[this.partitionsNodes.length];
        boolean changed = false;
        Int2LongFunction partitionNodesResolver = this.partitionNodeResolver(other);
        for (int i = 0; i < this.partitionsNodes.length; ++i) {
            long newNodes = this.partitionsNodes[i] & partitionNodesResolver.get(i);
            if (newNodes == 0L) {
                newNodes = this.partitionsNodes[i];
            }
            if (newNodes != this.partitionsNodes[i]) {
                changed = true;
            }
            newPartitionsNodes[i] = newNodes;
        }
        if (changed) {
            return new PartitionedTarget(false, newPartitionsNodes, this.enlistmentConsistencyTokens);
        }
        return this;
    }

    private Int2LongFunction partitionNodeResolver(ExecutionTarget other) {
        Int2LongFunction partitionNodesResolver;
        if (other instanceof PartitionedTarget && ((PartitionedTarget)other).partitionsNodes.length == this.partitionsNodes.length) {
            PartitionedTarget otherPartitioned = (PartitionedTarget)other;
            partitionNodesResolver = partId -> otherPartitioned.partitionsNodes[partId];
        } else {
            long otherNodes = ((AbstractTarget)other).nodes;
            partitionNodesResolver = partId -> otherNodes;
        }
        return partitionNodesResolver;
    }

    @Override
    ExecutionTarget colocate(AllOfTarget other) throws ColocationMappingException {
        return PartitionedTarget.colocate(other, this);
    }

    @Override
    ExecutionTarget colocate(OneOfTarget other) throws ColocationMappingException {
        return PartitionedTarget.colocate(other, this);
    }

    @Override
    ExecutionTarget colocate(PartitionedTarget other) throws ColocationMappingException {
        return PartitionedTarget.colocate(this, other);
    }

    @Override
    ExecutionTarget colocate(SomeOfTarget other) throws ColocationMappingException {
        return PartitionedTarget.colocate(this, other);
    }

    private static long computeNodes(long[] partitionsNodes) {
        long nodes = 0L;
        for (long nodesOfPartition : partitionsNodes) {
            nodes |= nodesOfPartition;
        }
        return nodes;
    }
}

