/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.table.AntiHijackAsyncCursor;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.jetbrains.annotations.Nullable;

public class AntiHijackAsyncResultSet<T>
extends AntiHijackAsyncCursor<T>
implements AsyncResultSet<T>,
Wrapper {
    private final AsyncResultSet<T> resultSet;
    private final Executor asyncContinuationExecutor;

    AntiHijackAsyncResultSet(AsyncResultSet<T> resultSet, Executor asyncContinuationExecutor) {
        super(resultSet, asyncContinuationExecutor);
        this.resultSet = resultSet;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Nullable
    public ResultSetMetadata metadata() {
        return this.resultSet.metadata();
    }

    public boolean hasRowSet() {
        return this.resultSet.hasRowSet();
    }

    public long affectedRows() {
        return this.resultSet.affectedRows();
    }

    public boolean wasApplied() {
        return this.resultSet.wasApplied();
    }

    public CompletableFuture<? extends AsyncResultSet<T>> fetchNextPage() {
        return PublicApiThreading.preventThreadHijack((CompletableFuture)this.resultSet.fetchNextPage(), (Executor)this.asyncContinuationExecutor).thenApply(resultSet -> new AntiHijackAsyncResultSet<T>(resultSet, this.asyncContinuationExecutor));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.resultSet);
    }
}

