/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.eventlog.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collection;
import org.apache.ignite.internal.eventlog.api.Event;
import org.apache.ignite.internal.eventlog.event.EventUser;
import org.apache.ignite.internal.eventlog.ser.EventSerializer;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class JacksonBasedJsonSerializer
implements EventSerializer {
    private final ObjectMapper mapper = new ObjectMapper();

    public JacksonBasedJsonSerializer() {
        this.mapper.registerModule(JacksonBasedJsonSerializer.eventUserModule());
    }

    private static Module eventUserModule() {
        SimpleModule module = new SimpleModule("EventUser");
        module.addSerializer(EventUser.class, (JsonSerializer)new EventUserJacksonSerializer());
        return module;
    }

    @Override
    public String serialize(Event event) {
        try {
            return this.mapper.writeValueAsString((Object)event);
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Failed to serialize event", (Throwable)e);
        }
    }

    @Override
    public byte[] serialize(Collection<Event> event) {
        try {
            return this.mapper.writeValueAsBytes(event);
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Failed to serialize events", (Throwable)e);
        }
    }

    private static class EventUserJacksonSerializer
    extends StdSerializer<EventUser> {
        EventUserJacksonSerializer() {
            this(null);
        }

        EventUserJacksonSerializer(@Nullable Class<EventUser> e) {
            super(e);
        }

        public void serialize(EventUser value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField("username", value.username());
            jgen.writeStringField("authenticationProvider", value.authenticationProvider());
            jgen.writeEndObject();
        }
    }
}

