/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.replicator.ReplicatorRecoverableExceptions;
import org.apache.ignite.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite.internal.tx.impl.PlacementDriverHelper;
import org.apache.ignite.internal.tx.impl.TxMessageSender;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicatedInfo;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.jetbrains.annotations.Nullable;

public class WriteIntentSwitchProcessor {
    private static final IgniteLogger LOG = Loggers.forClass(WriteIntentSwitchProcessor.class);
    private final PlacementDriverHelper placementDriverHelper;
    private final TxMessageSender txMessageSender;
    private final TopologyService topologyService;

    public WriteIntentSwitchProcessor(PlacementDriverHelper placementDriverHelper, TxMessageSender txMessageSender, TopologyService topologyService) {
        this.placementDriverHelper = placementDriverHelper;
        this.txMessageSender = txMessageSender;
        this.topologyService = topologyService;
    }

    public CompletableFuture<WriteIntentSwitchReplicatedInfo> switchLocalWriteIntents(EnlistedPartitionGroup partition, UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        String localNodeName = this.topologyService.localMember().name();
        return this.txMessageSender.switchWriteIntents(localNodeName, partition, txId, commit, commitTimestamp);
    }

    public CompletableFuture<WriteIntentSwitchReplicatedInfo> switchWriteIntentsWithRetry(boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId, EnlistedPartitionGroup partition) {
        return ((CompletableFuture)((CompletableFuture)this.placementDriverHelper.awaitPrimaryReplicaWithExceptionHandling(partition.groupId()).thenCompose(leaseHolder -> this.txMessageSender.switchWriteIntents(leaseHolder.getLeaseholder(), partition, txId, commit, commitTimestamp))).handle((res, ex) -> {
            if (ex != null) {
                Throwable cause = ExceptionUtils.unwrapCause((Throwable)ex);
                if (ReplicatorRecoverableExceptions.isRecoverable((Throwable)cause)) {
                    LOG.debug("Failed to switch write intents for Tx. The operation will be retried [txId={}, exception={}].", new Object[]{txId, ex.getClass().getSimpleName() + ": " + ex.getMessage()});
                    return this.switchWriteIntentsWithRetry(commit, commitTimestamp, txId, partition);
                }
                LOG.info("Failed to switch write intents for Tx [txId={}].", new Object[]{txId, ex});
                return CompletableFuture.failedFuture(ex);
            }
            return CompletableFutures.nullCompletedFuture();
        })).thenCompose(Function.identity());
    }
}

