/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.jdbc;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class JdbcQueryCursor<T>
implements AsyncSqlCursor<T> {
    private final long maxRows;
    private final AsyncSqlCursor<T> cur;
    private final AtomicLong fetched = new AtomicLong();

    public JdbcQueryCursor(int maxRows, AsyncSqlCursor<T> cur) {
        this.maxRows = maxRows;
        this.cur = cur;
    }

    public CompletableFuture<AsyncCursor.BatchedResult<T>> requestNextAsync(int rows) {
        long fetched0 = this.fetched.addAndGet(rows);
        assert (this.cur != null) : "non initialized cursor";
        return this.cur.requestNextAsync(rows).thenApply(batch -> {
            if (this.maxRows == 0L || fetched0 < this.maxRows) {
                return batch;
            }
            int remainCnt = (int)(this.maxRows - fetched0 + (long)rows);
            List remainItems = remainCnt < batch.items().size() ? batch.items().subList(0, remainCnt) : batch.items();
            return new AsyncCursor.BatchedResult(remainItems, false);
        });
    }

    public CompletableFuture<Void> closeAsync() {
        return this.cur.closeAsync();
    }

    public CompletableFuture<Void> cancelAsync(AsyncDataCursor.CancellationReason reason) {
        return this.cur.cancelAsync(reason);
    }

    public CompletableFuture<Void> onClose() {
        return this.cur.onClose();
    }

    public CompletableFuture<Void> onFirstPageReady() {
        return this.cur.onFirstPageReady();
    }

    public SqlQueryType queryType() {
        return this.cur.queryType();
    }

    public ResultSetMetadata metadata() {
        return this.cur.metadata();
    }

    @Nullable
    public PartitionAwarenessMetadata partitionAwarenessMetadata() {
        return this.cur.partitionAwarenessMetadata();
    }

    public boolean hasNextResult() {
        return this.cur.hasNextResult();
    }

    public CompletableFuture<AsyncSqlCursor<T>> nextResult() {
        if (!this.hasNextResult()) {
            throw new NoSuchElementException("Query has no more results");
        }
        return this.cur.nextResult();
    }
}

