/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.kill;

import org.apache.ignite.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlKill;
import org.apache.ignite.internal.tostring.S;

public class KillCommand {
    private final String operationId;
    private final CancellableOperationType type;
    private final boolean noWait;

    public KillCommand(String operationId, CancellableOperationType type, boolean noWait) {
        this.operationId = operationId;
        this.noWait = noWait;
        this.type = type;
    }

    public static KillCommand fromSqlCall(IgniteSqlKill sqlKill) {
        String operationId = (String)sqlKill.objectId().getValueAs(String.class);
        assert (operationId != null);
        CancellableOperationType type = CancellableOperationType.valueOf((String)sqlKill.objectType().name());
        return new KillCommand(operationId, type, Boolean.TRUE.equals(sqlKill.noWait()));
    }

    public String operationId() {
        return this.operationId;
    }

    public CancellableOperationType type() {
        return this.type;
    }

    public boolean noWait() {
        return this.noWait;
    }

    public String toString() {
        return S.toString(KillCommand.class, (Object)this);
    }
}

