/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.internal.metastorage.command.GetCommand;
import org.apache.ignite.internal.metastorage.command.GetCommandBuilder;
import org.apache.ignite.internal.metastorage.command.GetCommandSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class GetCommandImpl
implements GetCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 20;
    @IgniteToStringInclude
    private final ByteBuffer key;
    @IgniteToStringInclude
    private final long revision;

    private GetCommandImpl(ByteBuffer key, long revision) {
        this.key = key;
        this.revision = revision;
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public long revision() {
        return this.revision;
    }

    public MessageSerializer serializer() {
        return GetCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(GetCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 20;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetCommandImpl otherMessage = (GetCommandImpl)other;
        return Objects.equals(this.key, otherMessage.key) && this.revision == otherMessage.revision;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.revision, this.key);
        return result;
    }

    public GetCommandImpl clone() {
        try {
            return (GetCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetCommandBuilder {
        private ByteBuffer key;
        private long revision;

        private Builder() {
        }

        @Override
        public GetCommandBuilder key(ByteBuffer key) {
            Objects.requireNonNull(key, "key is not marked @Nullable");
            this.key = key;
            return this;
        }

        @Override
        public GetCommandBuilder revision(long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public long revision() {
            return this.revision;
        }

        @Override
        public GetCommand build() {
            return new GetCommandImpl(Objects.requireNonNull(this.key, "key is not marked @Nullable"), this.revision);
        }
    }
}

