/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.ChannelTypeRegistry;
import org.apache.ignite.internal.util.ArrayUtils;

class ArrayChannelTypeRegistry
implements ChannelTypeRegistry {
    private final ChannelType[] array;

    ArrayChannelTypeRegistry(ChannelType ... channelTypes) {
        assert (!ArrayUtils.nullOrEmpty((Object[])channelTypes));
        this.array = channelTypes;
    }

    @Override
    public ChannelType get(short id) {
        assert (id >= 0 && id < this.array.length) : "Channel type is not registered: " + id;
        return this.array[id];
    }

    @Override
    public Collection<ChannelType> getAll() {
        return Collections.unmodifiableCollection(Arrays.asList(this.array));
    }
}

