/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.criteria;

import java.util.Collection;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.table.criteria.Column;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaVisitor;
import org.apache.ignite.table.criteria.Expression;
import org.apache.ignite.table.criteria.Parameter;
import org.jetbrains.annotations.Nullable;

class ColumnValidator
implements CriteriaVisitor<Collection<String>> {
    static final ColumnValidator INSTANCE = new ColumnValidator();

    ColumnValidator() {
    }

    public <T> void visit(Parameter<T> argument, @Nullable Collection<String> context) {
    }

    public <T> void visit(Column column, @Nullable Collection<String> context) {
        String colName = column.getName();
        if (!CollectionUtils.nullOrEmpty(context) && !context.contains(colName)) {
            throw new IllegalArgumentException("Unexpected column name: " + colName);
        }
    }

    public <T> void visit(Expression expression, @Nullable Collection<String> context) {
        for (Criteria element : expression.getElements()) {
            element.accept((CriteriaVisitor)this, context);
        }
    }

    public <T> void visit(Criteria criteria, @Nullable Collection<String> context) {
        criteria.accept((CriteriaVisitor)this, context);
    }
}

