/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.TableModify;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public class TableAccessMap {
    private final Map<List<String>, Mode> accessMap;

    public TableAccessMap() {
        this.accessMap = Collections.EMPTY_MAP;
    }

    public TableAccessMap(RelNode rel) {
        this.accessMap = new HashMap<List<String>, Mode>();
        RelOptUtil.go(new TableRelVisitor(), rel);
    }

    public TableAccessMap(List<String> table, Mode mode) {
        this.accessMap = new HashMap<List<String>, Mode>();
        this.accessMap.put(table, mode);
    }

    public Set<List<String>> getTablesAccessed() {
        return this.accessMap.keySet();
    }

    public boolean isTableAccessed(List<String> tableName) {
        return this.accessMap.containsKey(tableName);
    }

    public boolean isTableAccessedForRead(List<String> tableName) {
        Mode mode = this.getTableAccessMode(tableName);
        return mode == Mode.READ_ACCESS || mode == Mode.READWRITE_ACCESS;
    }

    public boolean isTableAccessedForWrite(List<String> tableName) {
        Mode mode = this.getTableAccessMode(tableName);
        return mode == Mode.WRITE_ACCESS || mode == Mode.READWRITE_ACCESS;
    }

    public Mode getTableAccessMode(List<String> tableName) {
        Mode mode = this.accessMap.get(tableName);
        if (mode == null) {
            return Mode.NO_ACCESS;
        }
        return mode;
    }

    public List<String> getQualifiedName(RelOptTable table) {
        return table.getQualifiedName();
    }

    private class TableRelVisitor
    extends RelVisitor {
        private TableRelVisitor() {
        }

        @Override
        public void visit(RelNode p, int ordinal, @Nullable RelNode parent) {
            super.visit(p, ordinal, parent);
            RelOptTable table = p.getTable();
            if (table == null) {
                return;
            }
            Mode newAccess = p instanceof TableModify ? Mode.WRITE_ACCESS : Mode.READ_ACCESS;
            List<String> key = TableAccessMap.this.getQualifiedName(table);
            Mode oldAccess = (Mode)((Object)TableAccessMap.this.accessMap.get(key));
            if (oldAccess != null && oldAccess != newAccess) {
                newAccess = Mode.READWRITE_ACCESS;
            }
            TableAccessMap.this.accessMap.put(key, newAccess);
        }
    }

    public static enum Mode {
        NO_ACCESS,
        READ_ACCESS,
        WRITE_ACCESS,
        READWRITE_ACCESS;

    }
}

