/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueInt;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public final class DateTimeFunctions {
    private static final HashMap<String, Integer> DATE_PART = new HashMap();
    private static volatile String[][] MONTHS_AND_WEEKS;

    public static Value dateadd(String string, long l, Value value) {
        int n = DateTimeFunctions.getDatePart(string);
        if (n != 126 && n != 128 && n != 129 && (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE)) {
            throw DbException.getInvalidValueException("DATEADD count", l);
        }
        boolean bl = !(value instanceof ValueTime);
        boolean bl2 = !(value instanceof ValueDate);
        boolean bl3 = false;
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
        long l2 = lArray[0];
        long l3 = lArray[1];
        switch (n) {
            case 113: {
                l *= 3L;
            }
            case 110: 
            case 116: {
                if (!bl) {
                    throw DbException.getInvalidValueException("DATEADD time part", string);
                }
                long l4 = DateTimeUtils.yearFromDateValue(l2);
                long l5 = DateTimeUtils.monthFromDateValue(l2);
                int n2 = DateTimeUtils.dayFromDateValue(l2);
                if (n == 116) {
                    l4 += l;
                } else {
                    l5 += l;
                }
                l2 = DateTimeUtils.dateValueFromDenormalizedDate(l4, l5, n2);
                return DateTimeUtils.dateTimeToValue(value, l2, l3, bl3);
            }
            case 115: 
            case 124: {
                l *= 7L;
            }
            case 105: 
            case 106: 
            case 107: 
            case 125: {
                if (!bl) {
                    throw DbException.getInvalidValueException("DATEADD time part", string);
                }
                l2 = DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(l2) + l);
                return DateTimeUtils.dateTimeToValue(value, l2, l3, bl3);
            }
            case 108: {
                l *= 3600000000000L;
                break;
            }
            case 109: {
                l *= 60000000000L;
                break;
            }
            case 114: 
            case 127: {
                l *= 1000000000L;
                break;
            }
            case 126: {
                l *= 1000000L;
                break;
            }
            case 128: {
                l *= 1000L;
                break;
            }
            case 129: {
                break;
            }
            case 130: {
                l *= 60L;
            }
            case 131: {
                if (!(value instanceof ValueTimestampTimeZone)) {
                    throw DbException.getUnsupportedException("DATEADD " + string);
                }
                return ValueTimestampTimeZone.fromDateValueAndNanos(l2, l3, (short)(l += (long)((ValueTimestampTimeZone)value).getTimeZoneOffsetMins()));
            }
            default: {
                throw DbException.getUnsupportedException("DATEADD " + string);
            }
        }
        if (!bl2) {
            bl3 = true;
        }
        if ((l3 += l) >= 86400000000000L || l3 < 0L) {
            long l6 = l3 >= 86400000000000L ? l3 / 86400000000000L : (l3 - 86400000000000L + 1L) / 86400000000000L;
            return DateTimeUtils.dateTimeToValue(value, DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(l2) + l6), l3 -= l6 * 86400000000000L, bl3);
        }
        return DateTimeUtils.dateTimeToValue(value, l2, l3, bl3);
    }

    public static long datediff(String string, Value value, Value value2) {
        int n = DateTimeFunctions.getDatePart(string);
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
        long l = lArray[0];
        long l2 = DateTimeUtils.absoluteDayFromDateValue(l);
        long[] lArray2 = DateTimeUtils.dateAndTimeFromValue(value2);
        long l3 = lArray2[0];
        long l4 = DateTimeUtils.absoluteDayFromDateValue(l3);
        switch (n) {
            case 108: 
            case 109: 
            case 114: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                long l5 = lArray[1];
                long l6 = lArray2[1];
                switch (n) {
                    case 129: {
                        return (l4 - l2) * 86400000000000L + (l6 - l5);
                    }
                    case 128: {
                        return (l4 - l2) * 86400000000L + (l6 / 1000L - l5 / 1000L);
                    }
                    case 126: {
                        return (l4 - l2) * 86400000L + (l6 / 1000000L - l5 / 1000000L);
                    }
                    case 114: 
                    case 127: {
                        return (l4 - l2) * 86400L + (l6 / 1000000000L - l5 / 1000000000L);
                    }
                    case 109: {
                        return (l4 - l2) * 1440L + (l6 / 60000000000L - l5 / 60000000000L);
                    }
                    case 108: {
                        return (l4 - l2) * 24L + (l6 / 3600000000000L - l5 / 3600000000000L);
                    }
                }
            }
            case 105: 
            case 106: 
            case 107: 
            case 125: {
                return l4 - l2;
            }
            case 115: {
                return DateTimeFunctions.weekdiff(l2, l4, 0);
            }
            case 124: {
                return DateTimeFunctions.weekdiff(l2, l4, 1);
            }
            case 110: {
                return (DateTimeUtils.yearFromDateValue(l3) - DateTimeUtils.yearFromDateValue(l)) * 12 + DateTimeUtils.monthFromDateValue(l3) - DateTimeUtils.monthFromDateValue(l);
            }
            case 113: {
                return (DateTimeUtils.yearFromDateValue(l3) - DateTimeUtils.yearFromDateValue(l)) * 4 + (DateTimeUtils.monthFromDateValue(l3) - 1) / 3 - (DateTimeUtils.monthFromDateValue(l) - 1) / 3;
            }
            case 116: {
                return DateTimeUtils.yearFromDateValue(l3) - DateTimeUtils.yearFromDateValue(l);
            }
            case 130: 
            case 131: {
                int n2 = value instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)value).getTimeZoneOffsetMins() : DateTimeUtils.getTimeZoneOffsetMillis(null, l, lArray[1]);
                int n3 = value2 instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)value2).getTimeZoneOffsetMins() : DateTimeUtils.getTimeZoneOffsetMillis(null, l3, lArray2[1]);
                if (n == 130) {
                    return n3 / 60 - n2 / 60;
                }
                return n3 - n2;
            }
        }
        throw DbException.getUnsupportedException("DATEDIFF " + string);
    }

    public static Value extract(String string, Value value) {
        Value value2;
        int n = DateTimeFunctions.getDatePart(string);
        if (n != 127) {
            value2 = ValueInt.get(DateTimeFunctions.getIntDatePart(value, n));
        } else {
            long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
            long l = lArray[0];
            long l2 = lArray[1];
            BigDecimal bigDecimal = new BigDecimal(l2);
            BigDecimal bigDecimal2 = new BigDecimal(DateTimeUtils.absoluteDayFromDateValue(l));
            BigDecimal bigDecimal3 = new BigDecimal(1000000000);
            BigDecimal bigDecimal4 = new BigDecimal(86400L);
            if (value instanceof ValueTime) {
                value2 = ValueDecimal.get(bigDecimal.divide(bigDecimal3));
            } else if (value instanceof ValueDate) {
                value2 = ValueDecimal.get(bigDecimal2.multiply(bigDecimal4));
            } else if (value instanceof ValueTimestampTimeZone) {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                BigDecimal bigDecimal5 = new BigDecimal(valueTimestampTimeZone.getTimeZoneOffsetMins() * 60);
                value2 = ValueDecimal.get(bigDecimal.divide(bigDecimal3).add(bigDecimal2.multiply(bigDecimal4)).subtract(bigDecimal5));
            } else {
                value2 = ValueDecimal.get(bigDecimal.divide(bigDecimal3).add(bigDecimal2.multiply(bigDecimal4)));
            }
        }
        return value2;
    }

    public static Value truncateDate(String string, Value value) {
        Value value2;
        long l;
        int n = DateTimeFunctions.getDatePart(string);
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
        long l2 = lArray[0];
        long l3 = lArray[1];
        switch (n) {
            case 128: {
                long l4 = 1000L;
                long l5 = l3 / l4;
                l = l5 * l4;
                break;
            }
            case 126: {
                long l6 = 1000000L;
                long l7 = l3 / l6;
                l = l7 * l6;
                break;
            }
            case 114: {
                long l8 = 1000000000L;
                long l9 = l3 / l8;
                l = l9 * l8;
                break;
            }
            case 109: {
                long l10 = 60000000000L;
                long l11 = l3 / l10;
                l = l11 * l10;
                break;
            }
            case 108: {
                long l12 = 3600000000000L;
                long l13 = l3 / l12;
                l = l13 * l12;
                break;
            }
            case 105: {
                l = 0L;
                break;
            }
            case 115: {
                long l14 = DateTimeUtils.absoluteDayFromDateValue(l2);
                int n2 = DateTimeUtils.getDayOfWeekFromAbsolute(l14, 1);
                if (n2 != 1) {
                    l2 = DateTimeUtils.dateValueFromAbsoluteDay(l14 - (long)n2 + 1L);
                }
                l = 0L;
                break;
            }
            case 110: {
                long l15 = DateTimeUtils.yearFromDateValue(l2);
                int n3 = DateTimeUtils.monthFromDateValue(l2);
                l2 = DateTimeUtils.dateValue(l15, n3, 1);
                l = 0L;
                break;
            }
            case 113: {
                long l16 = DateTimeUtils.yearFromDateValue(l2);
                int n4 = DateTimeUtils.monthFromDateValue(l2);
                n4 = (n4 - 1) / 3 * 3 + 1;
                l2 = DateTimeUtils.dateValue(l16, n4, 1);
                l = 0L;
                break;
            }
            case 116: {
                long l17 = DateTimeUtils.yearFromDateValue(l2);
                l2 = DateTimeUtils.dateValue(l17, 1, 1);
                l = 0L;
                break;
            }
            case 132: {
                long l18 = DateTimeUtils.yearFromDateValue(l2);
                l18 = l18 / 10L * 10L;
                l2 = DateTimeUtils.dateValue(l18, 1, 1);
                l = 0L;
                break;
            }
            case 133: {
                long l19 = DateTimeUtils.yearFromDateValue(l2);
                l19 = (l19 - 1L) / 100L * 100L + 1L;
                l2 = DateTimeUtils.dateValue(l19, 1, 1);
                l = 0L;
                break;
            }
            case 134: {
                long l20 = DateTimeUtils.yearFromDateValue(l2);
                l20 = (l20 - 1L) / 1000L * 1000L + 1L;
                l2 = DateTimeUtils.dateValue(l20, 1, 1);
                l = 0L;
                break;
            }
            default: {
                throw DbException.getUnsupportedException(string);
            }
        }
        if (value instanceof ValueTimestampTimeZone) {
            ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
            value2 = ValueTimestampTimeZone.fromDateValueAndNanos(l2, l, valueTimestampTimeZone.getTimeZoneOffsetMins());
        } else {
            value2 = ValueTimestamp.fromDateValueAndNanos(l2, l);
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String string, String string2, String string3) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = DateTimeFunctions.getDateFormat(string, string2, string3);
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(date);
        }
    }

    private static SimpleDateFormat getDateFormat(String string, String string2, String string3) {
        try {
            SimpleDateFormat simpleDateFormat;
            if (string2 == null) {
                simpleDateFormat = new SimpleDateFormat(string);
            } else {
                Locale locale = new Locale(string2);
                simpleDateFormat = new SimpleDateFormat(string, locale);
            }
            if (string3 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
            }
            return simpleDateFormat;
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string + "/" + string2 + "/" + string3);
        }
    }

    private static int getDatePart(String string) {
        Integer n = DATE_PART.get(StringUtils.toUpperEnglish(string));
        if (n == null) {
            throw DbException.getInvalidValueException("date part", string);
        }
        return n;
    }

    public static int getIntDatePart(Value value, int n) {
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
        long l = lArray[0];
        long l2 = lArray[1];
        switch (n) {
            case 116: {
                return DateTimeUtils.yearFromDateValue(l);
            }
            case 110: {
                return DateTimeUtils.monthFromDateValue(l);
            }
            case 105: {
                return DateTimeUtils.dayFromDateValue(l);
            }
            case 108: {
                return (int)(l2 / 3600000000000L % 24L);
            }
            case 109: {
                return (int)(l2 / 60000000000L % 60L);
            }
            case 114: {
                return (int)(l2 / 1000000000L % 60L);
            }
            case 126: {
                return (int)(l2 / 1000000L % 1000L);
            }
            case 128: {
                return (int)(l2 / 1000L % 1000000L);
            }
            case 129: {
                return (int)(l2 % 1000000000L);
            }
            case 107: {
                return DateTimeUtils.getDayOfYear(l);
            }
            case 106: {
                return DateTimeUtils.getSundayDayOfWeek(l);
            }
            case 115: {
                GregorianCalendar gregorianCalendar = DateTimeUtils.getCalendar();
                return DateTimeUtils.getWeekOfYear(l, gregorianCalendar.getFirstDayOfWeek() - 1, gregorianCalendar.getMinimalDaysInFirstWeek());
            }
            case 113: {
                return (DateTimeUtils.monthFromDateValue(l) - 1) / 3 + 1;
            }
            case 123: {
                return DateTimeUtils.getIsoWeekYear(l);
            }
            case 124: {
                return DateTimeUtils.getIsoWeekOfYear(l);
            }
            case 125: {
                return DateTimeUtils.getIsoDayOfWeek(l);
            }
            case 130: 
            case 131: {
                int n2 = value instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)value).getTimeZoneOffsetMins() : DateTimeUtils.getTimeZoneOffsetMillis(null, l, l2);
                if (n == 130) {
                    return n2 / 60;
                }
                return n2 % 60;
            }
        }
        throw DbException.getUnsupportedException("getDatePart(" + value + ", " + n + ')');
    }

    public static String[] getMonthsAndWeeks(int n) {
        String[][] stringArray = MONTHS_AND_WEEKS;
        if (stringArray == null) {
            stringArray = new String[2][];
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(Locale.ENGLISH);
            stringArray[0] = dateFormatSymbols.getMonths();
            stringArray[1] = dateFormatSymbols.getWeekdays();
            MONTHS_AND_WEEKS = stringArray;
        }
        return stringArray[n];
    }

    public static boolean isDatePart(String string) {
        return DATE_PART.containsKey(StringUtils.toUpperEnglish(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String string, String string2, String string3, String string4) {
        SimpleDateFormat simpleDateFormat = DateTimeFunctions.getDateFormat(string2, string3, string4);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string);
        }
    }

    private static long weekdiff(long l, long l2, int n) {
        long l3 = (l += (long)(4 - n)) / 7L;
        if (l < 0L && l3 * 7L != l) {
            --l3;
        }
        long l4 = (l2 += (long)(4 - n)) / 7L;
        if (l2 < 0L && l4 * 7L != l2) {
            --l4;
        }
        return l4 - l3;
    }

    private DateTimeFunctions() {
    }

    static {
        DATE_PART.put("SQL_TSI_YEAR", 116);
        DATE_PART.put("YEAR", 116);
        DATE_PART.put("YYYY", 116);
        DATE_PART.put("YY", 116);
        DATE_PART.put("SQL_TSI_MONTH", 110);
        DATE_PART.put("MONTH", 110);
        DATE_PART.put("MM", 110);
        DATE_PART.put("M", 110);
        DATE_PART.put("QUARTER", 113);
        DATE_PART.put("SQL_TSI_WEEK", 115);
        DATE_PART.put("WW", 115);
        DATE_PART.put("WK", 115);
        DATE_PART.put("WEEK", 115);
        DATE_PART.put("ISO_WEEK", 124);
        DATE_PART.put("DAY", 105);
        DATE_PART.put("DD", 105);
        DATE_PART.put("D", 105);
        DATE_PART.put("SQL_TSI_DAY", 105);
        DATE_PART.put("DAY_OF_WEEK", 106);
        DATE_PART.put("DAYOFWEEK", 106);
        DATE_PART.put("DOW", 106);
        DATE_PART.put("ISO_DAY_OF_WEEK", 125);
        DATE_PART.put("DAYOFYEAR", 107);
        DATE_PART.put("DAY_OF_YEAR", 107);
        DATE_PART.put("DY", 107);
        DATE_PART.put("DOY", 107);
        DATE_PART.put("SQL_TSI_HOUR", 108);
        DATE_PART.put("HOUR", 108);
        DATE_PART.put("HH", 108);
        DATE_PART.put("SQL_TSI_MINUTE", 109);
        DATE_PART.put("MINUTE", 109);
        DATE_PART.put("MI", 109);
        DATE_PART.put("N", 109);
        DATE_PART.put("SQL_TSI_SECOND", 114);
        DATE_PART.put("SECOND", 114);
        DATE_PART.put("SS", 114);
        DATE_PART.put("S", 114);
        DATE_PART.put("MILLISECOND", 126);
        DATE_PART.put("MILLISECONDS", 126);
        DATE_PART.put("MS", 126);
        DATE_PART.put("EPOCH", 127);
        DATE_PART.put("MICROSECOND", 128);
        DATE_PART.put("MICROSECONDS", 128);
        DATE_PART.put("MCS", 128);
        DATE_PART.put("NANOSECOND", 129);
        DATE_PART.put("NS", 129);
        DATE_PART.put("TIMEZONE_HOUR", 130);
        DATE_PART.put("TIMEZONE_MINUTE", 131);
        DATE_PART.put("DECADE", 132);
        DATE_PART.put("CENTURY", 133);
        DATE_PART.put("MILLENNIUM", 134);
    }
}

