/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security.thread;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.thread.SecurityAwareCallable;
import org.apache.ignite.internal.processors.security.thread.SecurityAwareRunnable;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public class SecurityAwareThreadPoolExecutor
extends IgniteThreadPoolExecutor {
    private final IgniteSecurity security;

    public SecurityAwareThreadPoolExecutor(IgniteSecurity security, String threadNamePrefix, String igniteInstanceName, int corePoolSize, int maxPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQ, byte plc, Thread.UncaughtExceptionHandler eHnd) {
        super(threadNamePrefix, igniteInstanceName, corePoolSize, maxPoolSize, keepAliveTime, workQ, plc, eHnd);
        this.security = security;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        return super.submit(SecurityAwareCallable.of(this.security, task));
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T res) {
        return super.submit(SecurityAwareRunnable.of(this.security, task), res);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        return super.submit(SecurityAwareRunnable.of(this.security, task));
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return super.invokeAll(SecurityAwareCallable.of(this.security, tasks));
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return super.invokeAll(SecurityAwareCallable.of(this.security, tasks), timeout, unit);
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)super.invokeAny(SecurityAwareCallable.of(this.security, tasks));
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)super.invokeAny(SecurityAwareCallable.of(this.security, tasks), timeout, unit);
    }

    @Override
    public void execute(@NotNull Runnable cmd) {
        super.execute(SecurityAwareRunnable.of(this.security, cmd));
    }
}

