/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryUtils;

public class QueryIndexRowHandler
implements InlineIndexRowHandler {
    private final GridCacheContextInfo<?, ?> cacheInfo;
    private final List<InlineIndexKeyType> keyTypes;
    private final List<IndexKeyDefinition> keyDefs;
    private final IndexKeyTypeSettings keyTypeSettings;
    private final GridQueryProperty[] props;

    public QueryIndexRowHandler(GridQueryTypeDescriptor type, GridCacheContextInfo<?, ?> cacheInfo, LinkedHashMap<String, IndexKeyDefinition> keyDefs, List<InlineIndexKeyType> keyTypes, IndexKeyTypeSettings keyTypeSettings) {
        this.keyTypes = new ArrayList<InlineIndexKeyType>(keyTypes);
        this.keyDefs = new ArrayList<IndexKeyDefinition>(keyDefs.values());
        this.props = new GridQueryProperty[keyDefs.size()];
        int propIdx = 0;
        for (String propName : keyDefs.keySet()) {
            GridQueryProperty prop = propName.equals("_KEY") || propName.equals(type.keyFieldName()) || propName.equals(type.keyFieldAlias()) ? new KeyOrValPropertyWrapper(true, propName, type.keyClass()) : (propName.equals("_VAL") || propName.equals(type.valueFieldName()) || propName.equals(type.valueFieldAlias()) ? new KeyOrValPropertyWrapper(false, propName, type.valueClass()) : type.property(propName));
            assert (prop != null) : propName;
            this.props[propIdx++] = prop;
        }
        this.cacheInfo = cacheInfo;
        this.keyTypeSettings = keyTypeSettings;
    }

    @Override
    public IndexKey indexKey(int idx, CacheDataRow row) {
        try {
            return IndexKeyFactory.wrap(this.props[idx].value(row.key(), row.value()), this.keyDefs.get(idx).idxType(), (CacheObjectValueContext)this.cacheInfo.cacheContext().cacheObjectContext(), this.keyTypeSettings);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public List<InlineIndexKeyType> inlineIndexKeyTypes() {
        return this.keyTypes;
    }

    @Override
    public List<IndexKeyDefinition> indexKeyDefinitions() {
        return this.keyDefs;
    }

    @Override
    public IndexKeyTypeSettings indexKeyTypeSettings() {
        return this.keyTypeSettings;
    }

    @Override
    public int partition(CacheDataRow row) {
        Object key = this.unwrap(row.key());
        return this.cacheInfo.cacheContext().affinity().partition(key);
    }

    @Override
    public Object cacheKey(CacheDataRow row) {
        return this.unwrap(row.key());
    }

    @Override
    public Object cacheValue(CacheDataRow row) {
        return this.unwrap(row.value());
    }

    private Object unwrap(CacheObject val) {
        Object o = this.getBinaryObject(val);
        if (o != null) {
            return o;
        }
        CacheObjectContext coctx = this.cacheInfo.cacheContext().cacheObjectContext();
        return val.value(coctx, false);
    }

    private Object getBinaryObject(CacheObject o) {
        if (o instanceof BinaryObjectImpl) {
            ((BinaryObjectImpl)o).detachAllowed(true);
            o = ((BinaryObjectImpl)o).detach();
            return o;
        }
        return null;
    }

    private class KeyOrValPropertyWrapper
    extends QueryUtils.KeyOrValProperty {
        public KeyOrValPropertyWrapper(boolean key, String name, Class<?> cls) {
            super(key, name, cls);
        }

        @Override
        public Object value(Object key, Object val) {
            return this.key() ? QueryIndexRowHandler.this.unwrap((CacheObject)key) : QueryIndexRowHandler.this.unwrap((CacheObject)val);
        }
    }
}

