/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.hc.core5.http.nio.entity.FileEntityProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class TestFileEntityProducer {
    TestFileEntityProducer() {
    }

    @Test
    void testFileLengthMaxIntPlusOne(@TempDir Path tempFolder) throws IOException {
        Path path = Files.createFile(tempFolder.resolve("test.bin"), new FileAttribute[0]);
        try (RandomAccessFile raFile = new RandomAccessFile(path.toFile(), "rw");){
            long expectedLength = 0x80000000L;
            raFile.setLength(0x80000000L);
            FileEntityProducer fileEntityProducer = new FileEntityProducer(path.toFile());
            Assertions.assertEquals((long)0x80000000L, (long)fileEntityProducer.getContentLength());
        }
    }
}

