/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.io.IdentityInputStream;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestIdentityInputStream {
    TestIdentityInputStream() {
    }

    @Test
    void testBasicRead() throws Exception {
        byte[] input = new byte[]{97, 98, 99};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        try (IdentityInputStream in = new IdentityInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            byte[] tmp = new byte[2];
            Assertions.assertEquals((int)2, (int)in.read(tmp, 0, tmp.length));
            Assertions.assertEquals((int)97, (int)tmp[0]);
            Assertions.assertEquals((int)98, (int)tmp[1]);
            Assertions.assertEquals((int)99, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read(tmp, 0, tmp.length));
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read(tmp, 0, tmp.length));
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    void testClosedCondition() throws Exception {
        byte[] input = new byte[]{97, 98, 99};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        IdentityInputStream in = new IdentityInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        in.close();
        in.close();
        Assertions.assertEquals((int)0, (int)in.available());
        byte[] tmp = new byte[2];
        Assertions.assertThrows(StreamClosedException.class, () -> in.read(tmp, 0, tmp.length));
        Assertions.assertThrows(StreamClosedException.class, () -> in.read());
    }

    @Test
    void testAvailable() throws Exception {
        byte[] input = new byte[]{97, 98, 99};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(new BasicHttpTransportMetrics(), 16, 16, 1024, null);
        try (IdentityInputStream in = new IdentityInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            in.read();
            Assertions.assertEquals((int)2, (int)in.available());
        }
    }

    @Test
    void testAvailableInStream() throws Exception {
        byte[] input = new byte[]{97, 98, 99, 100, 101, 102};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(new BasicHttpTransportMetrics(), 16, 0, 1024, null);
        try (IdentityInputStream in = new IdentityInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            byte[] tmp = new byte[3];
            Assertions.assertEquals((int)3, (int)in.read(tmp));
            Assertions.assertEquals((int)3, (int)in.available());
        }
    }
}

