/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.Closeable;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.cache.HttpCacheCASOperation;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.InternalCacheStorage;
import org.apache.hc.client5.http.impl.cache.ResourceReference;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ManagedHttpCacheStorage
implements HttpCacheStorage,
Closeable {
    private final InternalCacheStorage entries;
    private final ReferenceQueue<HttpCacheEntry> morque;
    private final Set<ResourceReference> resources;
    private final AtomicBoolean active;
    private final ReentrantLock lock;

    public ManagedHttpCacheStorage(CacheConfig config) {
        this.entries = new InternalCacheStorage(config.getMaxCacheEntries(), null);
        this.morque = new ReferenceQueue();
        this.resources = new HashSet<ResourceReference>();
        this.active = new AtomicBoolean(true);
        this.lock = new ReentrantLock();
    }

    private void ensureValidState() {
        if (!this.isActive()) {
            throw new IllegalStateException("Cache has been shut down");
        }
    }

    private void keepResourceReference(HttpCacheEntry entry) {
        Resource resource = entry.getResource();
        if (resource != null) {
            ResourceReference ref = new ResourceReference(entry, this.morque);
            this.resources.add(ref);
        }
    }

    @Override
    public void putEntry(String url, HttpCacheEntry entry) throws ResourceIOException {
        Args.notNull((Object)url, (String)"URL");
        Args.notNull((Object)entry, (String)"Cache entry");
        this.ensureValidState();
        this.lock.lock();
        try {
            this.entries.put(url, entry);
            this.keepResourceReference(entry);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public HttpCacheEntry getEntry(String url) throws ResourceIOException {
        Args.notNull((Object)url, (String)"URL");
        this.ensureValidState();
        this.lock.lock();
        try {
            HttpCacheEntry httpCacheEntry = this.entries.get(url);
            return httpCacheEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeEntry(String url) throws ResourceIOException {
        Args.notNull((Object)url, (String)"URL");
        this.ensureValidState();
        this.lock.lock();
        try {
            this.entries.remove(url);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntry(String url, HttpCacheCASOperation casOperation) throws ResourceIOException {
        Args.notNull((Object)url, (String)"URL");
        Args.notNull((Object)casOperation, (String)"CAS operation");
        this.ensureValidState();
        this.lock.lock();
        try {
            HttpCacheEntry existing = this.entries.get(url);
            HttpCacheEntry updated = casOperation.execute(existing);
            this.entries.put(url, updated);
            if (existing != updated) {
                this.keepResourceReference(updated);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<String, HttpCacheEntry> getEntries(Collection<String> keys) throws ResourceIOException {
        Args.notNull(keys, (String)"Key");
        HashMap<String, HttpCacheEntry> resultMap = new HashMap<String, HttpCacheEntry>(keys.size());
        for (String key : keys) {
            HttpCacheEntry entry = this.getEntry(key);
            if (entry == null) continue;
            resultMap.put(key, entry);
        }
        return resultMap;
    }

    public void cleanResources() {
        if (this.isActive()) {
            ResourceReference ref;
            while ((ref = (ResourceReference)this.morque.poll()) != null) {
                this.lock.lock();
                try {
                    this.resources.remove(ref);
                }
                finally {
                    this.lock.unlock();
                }
                ref.getResource().dispose();
            }
        }
    }

    public void shutdown() {
        if (this.compareAndSet()) {
            this.lock.lock();
            try {
                this.entries.clear();
                for (ResourceReference ref : this.resources) {
                    ref.getResource().dispose();
                }
                this.resources.clear();
                while (this.morque.poll() != null) {
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() {
        if (this.compareAndSet()) {
            this.lock.lock();
            try {
                ResourceReference ref;
                while ((ref = (ResourceReference)this.morque.poll()) != null) {
                    this.resources.remove(ref);
                    ref.getResource().dispose();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    private boolean compareAndSet() {
        return this.active.compareAndSet(true, false);
    }
}

