/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionWithFileBasedStoreFileTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionWithFileBasedStoreFileTracker.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final TableDescriptor TD = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"file_based_tracker")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF)).build();
    private static final RegionInfo RI = RegionInfoBuilder.newBuilder((TableName)TD.getTableName()).build();
    @Rule
    public TestName name = new TestName();
    private HRegion region;

    @Before
    public void setUp() throws IOException {
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.set("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.FILE.name());
        this.region = HBaseTestingUtility.createRegionAndWAL(RI, UTIL.getDataTestDir(this.name.getMethodName()), conf, TD);
    }

    @After
    public void tearDown() throws IOException {
        if (this.region != null) {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
        }
        UTIL.cleanupTestDir();
    }

    @Test
    public void testFlushAndCompaction() throws IOException {
        int i;
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                int v = i * 10 + j;
                this.region.put(new Put(Bytes.toBytes((int)v)).addColumn(CF, CQ, Bytes.toBytes((int)v)));
            }
            this.region.flush(true);
            if (i % 3 != 2) continue;
            this.region.compact(true);
        }
        this.region.close();
        this.region = HRegion.openHRegion((HRegion)this.region, null);
        for (i = 0; i < 100; ++i) {
            Result result = this.region.get(new Get(Bytes.toBytes((int)i)));
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(CF, CQ)));
        }
    }
}

