/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.CloseRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestTRSPPersistUninitializedSubProc {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTRSPPersistUninitializedSubProc.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static TableName TN = TableName.valueOf((String)"tn");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(2);
        UTIL.getAdmin().balancerSwitch(false, true);
        UTIL.createTable(TN, CF);
        UTIL.waitTableAvailable(TN);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testServerCrash() throws Exception {
        HMaster master = UTIL.getHBaseCluster().getMaster();
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        RegionInfo region = (RegionInfo)UTIL.getAdmin().getRegions(TN).get(0);
        RegionStateNode rsn = master.getAssignmentManager().getRegionStates().getRegionStateNode(region);
        TRSPForTest trsp = new TRSPForTest((MasterProcedureEnv)procExec.getEnvironment(), region, null, false, TransitRegionStateProcedure.TransitionType.REOPEN);
        rsn.setProcedure((TransitRegionStateProcedure)trsp);
        procExec.submitProcedure((Procedure)trsp);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (Procedure)trsp);
        ProcedureTestingUtility.restart((ProcedureExecutor)procExec);
    }

    public static class TRSPForTest
    extends TransitRegionStateProcedure {
        private boolean injected = false;

        public TRSPForTest() {
        }

        public TRSPForTest(MasterProcedureEnv env, RegionInfo hri, ServerName assignCandidate, boolean forceNewPlan, TransitRegionStateProcedure.TransitionType type) {
            super(env, hri, assignCandidate, forceNewPlan, type);
        }

        protected Procedure[] execute(MasterProcedureEnv env) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
            Procedure[] subProcs = super.execute((Object)env);
            if (!this.injected && subProcs != null && subProcs[0] instanceof CloseRegionProcedure) {
                this.injected = true;
                ServerName sn = ((CloseRegionProcedure)subProcs[0]).targetServer;
                env.getMasterServices().getServerManager().expireServer(sn);
                try {
                    UTIL.waitFor(15000L, () -> env.getMasterServices().getProcedures().stream().anyMatch(p -> p instanceof ServerCrashProcedure && p.getState() != ProcedureProtos.ProcedureState.INITIALIZING));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                Thread.sleep(10000L);
            }
            return subProcs;
        }
    }
}

