/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestHFileBlockHeaderCorruption {
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileBlockHeaderCorruption.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileBlockHeaderCorruption.class);
    private final HFileTestRule hFileTestRule;
    @Rule
    public final RuleChain ruleChain;

    public TestHFileBlockHeaderCorruption() throws IOException {
        TestName testName = new TestName();
        this.hFileTestRule = new HFileTestRule(new HBaseTestingUtility(), testName);
        this.ruleChain = RuleChain.outerRule((TestRule)testName).around((TestRule)this.hFileTestRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecksumTypeCorruptionFirstBlock() throws Exception {
        try (HFileBlockChannelPosition firstBlock = null;){
            try (HFileBlockChannelPositionIterator it = new HFileBlockChannelPositionIterator(this.hFileTestRule);){
                Assert.assertTrue((boolean)it.hasNext());
                firstBlock = it.next();
            }
            Corrupter c = new Corrupter(firstBlock);
            TestHFileBlockHeaderCorruption.logHeader(firstBlock);
            c.write(HFileBlock.Header.CHECKSUM_TYPE_INDEX, ByteBuffer.wrap(new byte[]{-1}));
            TestHFileBlockHeaderCorruption.logHeader(firstBlock);
            try (Object it = new HFileBlockChannelPositionIterator(this.hFileTestRule);){
                CountingConsumer consumer = new CountingConsumer((HFileBlockChannelPositionIterator)it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(IOException.class).withMessage((Matcher<String>)Matchers.startsWith((String)"Unknown checksum type code")));
                }
                Assert.assertEquals((long)0L, (long)consumer.getItemsRead());
            }
            for (ChecksumType t : ChecksumType.values()) {
                this.testValidChecksumTypeReadBlock(t.getCode(), c, firstBlock);
            }
            c.restore();
            c.write(HFileBlock.Header.CHECKSUM_TYPE_INDEX, ByteBuffer.wrap(new byte[]{3}));
            TestHFileBlockHeaderCorruption.logHeader(firstBlock);
            it = new HFileBlockChannelPositionIterator(this.hFileTestRule);
            Throwable throwable = null;
            try {
                CountingConsumer consumer = new CountingConsumer((HFileBlockChannelPositionIterator)it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(IOException.class).withMessage((Matcher<String>)Matchers.startsWith((String)"Unknown checksum type code")));
                }
                Assert.assertEquals((long)0L, (long)consumer.getItemsRead());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (it != null) {
                    if (throwable != null) {
                        try {
                            ((HFileBlockChannelPositionIterator)it).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((HFileBlockChannelPositionIterator)it).close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecksumTypeCorruptionSecondBlock() throws Exception {
        try (HFileBlockChannelPosition secondBlock = null;){
            try (HFileBlockChannelPositionIterator it = new HFileBlockChannelPositionIterator(this.hFileTestRule);){
                Assert.assertTrue((boolean)it.hasNext());
                it.next();
                Assert.assertTrue((boolean)it.hasNext());
                secondBlock = it.next();
            }
            Corrupter c = new Corrupter(secondBlock);
            TestHFileBlockHeaderCorruption.logHeader(secondBlock);
            c.write(HFileBlock.Header.CHECKSUM_TYPE_INDEX, ByteBuffer.wrap(new byte[]{-1}));
            TestHFileBlockHeaderCorruption.logHeader(secondBlock);
            try (Object it = new HFileBlockChannelPositionIterator(this.hFileTestRule);){
                CountingConsumer consumer = new CountingConsumer((HFileBlockChannelPositionIterator)it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(RuntimeException.class).withMessage((Matcher<String>)Matchers.startsWith((String)"Unknown checksum type code")));
                }
                Assert.assertEquals((long)1L, (long)consumer.getItemsRead());
            }
            for (ChecksumType t : ChecksumType.values()) {
                this.testValidChecksumTypeReadBlock(t.getCode(), c, secondBlock);
            }
            c.restore();
            c.write(HFileBlock.Header.CHECKSUM_TYPE_INDEX, ByteBuffer.wrap(new byte[]{3}));
            TestHFileBlockHeaderCorruption.logHeader(secondBlock);
            it = new HFileBlockChannelPositionIterator(this.hFileTestRule);
            Throwable throwable = null;
            try {
                CountingConsumer consumer = new CountingConsumer((HFileBlockChannelPositionIterator)it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(RuntimeException.class).withMessage((Matcher<String>)Matchers.startsWith((String)"Unknown checksum type code")));
                }
                Assert.assertEquals((long)1L, (long)consumer.getItemsRead());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (it != null) {
                    if (throwable != null) {
                        try {
                            ((HFileBlockChannelPositionIterator)it).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((HFileBlockChannelPositionIterator)it).close();
                    }
                }
            }
        }
    }

    public void testValidChecksumTypeReadBlock(byte checksumTypeCode, Corrupter c, HFileBlockChannelPosition testBlock) throws IOException {
        c.restore();
        c.write(HFileBlock.Header.CHECKSUM_TYPE_INDEX, ByteBuffer.wrap(new byte[]{checksumTypeCode}));
        TestHFileBlockHeaderCorruption.logHeader(testBlock);
        try (HFileBlockChannelPositionIterator it = new HFileBlockChannelPositionIterator(this.hFileTestRule);){
            CountingConsumer consumer = new CountingConsumer(it);
            try {
                consumer.readFully();
            }
            catch (Exception e) {
                Assert.fail((String)"test fail: valid checksumType are not executing properly");
            }
            Assert.assertNotEquals((long)0L, (long)consumer.getItemsRead());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnDiskSizeWithoutHeaderCorruptionFirstBlock() throws Exception {
        try (HFileBlockChannelPosition firstBlock = null;){
            CountingConsumer consumer;
            try (HFileBlockChannelPositionIterator it = new HFileBlockChannelPositionIterator(this.hFileTestRule);){
                Assert.assertTrue((boolean)it.hasNext());
                firstBlock = it.next();
            }
            Corrupter c = new Corrupter(firstBlock);
            TestHFileBlockHeaderCorruption.logHeader(firstBlock);
            c.write(HFileBlock.Header.ON_DISK_SIZE_WITHOUT_HEADER_INDEX, ByteBuffer.wrap(Bytes.toBytes((int)Integer.MIN_VALUE)));
            TestHFileBlockHeaderCorruption.logHeader(firstBlock);
            try (HFileBlockChannelPositionIterator it = new HFileBlockChannelPositionIterator(this.hFileTestRule);){
                consumer = new CountingConsumer(it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(IOException.class).withMessage((Matcher<String>)Matchers.startsWith((String)"Invalid onDiskSizeWithHeader=")));
                }
                Assert.assertEquals((long)0L, (long)consumer.getItemsRead());
            }
            c.restore();
            c.write(HFileBlock.Header.ON_DISK_SIZE_WITHOUT_HEADER_INDEX, ByteBuffer.wrap(Bytes.toBytes((int)0)));
            TestHFileBlockHeaderCorruption.logHeader(firstBlock);
            it = new HFileBlockChannelPositionIterator(this.hFileTestRule);
            var4_6 = null;
            try {
                consumer = new CountingConsumer(it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(IllegalArgumentException.class));
                }
                Assert.assertEquals((long)0L, (long)consumer.getItemsRead());
            }
            catch (Throwable consumer2) {
                var4_6 = consumer2;
                throw consumer2;
            }
            finally {
                if (it != null) {
                    if (var4_6 != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable consumer2) {
                            var4_6.addSuppressed(consumer2);
                        }
                    } else {
                        it.close();
                    }
                }
            }
            c.restore();
            c.write(HFileBlock.Header.ON_DISK_SIZE_WITHOUT_HEADER_INDEX, ByteBuffer.wrap(Bytes.toBytes((int)Integer.MAX_VALUE)));
            TestHFileBlockHeaderCorruption.logHeader(firstBlock);
            it = new HFileBlockChannelPositionIterator(this.hFileTestRule);
            var4_6 = null;
            try {
                consumer = new CountingConsumer(it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(IOException.class).withMessage((Matcher<String>)Matchers.startsWith((String)"Invalid onDiskSizeWithHeader=")));
                }
                Assert.assertEquals((long)0L, (long)consumer.getItemsRead());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (it != null) {
                    if (var4_6 != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        it.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnDiskSizeWithoutHeaderCorruptionSecondBlock() throws Exception {
        try (HFileBlockChannelPosition secondBlock = null;){
            CountingConsumer consumer;
            try (HFileBlockChannelPositionIterator it = new HFileBlockChannelPositionIterator(this.hFileTestRule);){
                Assert.assertTrue((boolean)it.hasNext());
                it.next();
                Assert.assertTrue((boolean)it.hasNext());
                secondBlock = it.next();
            }
            Corrupter c = new Corrupter(secondBlock);
            TestHFileBlockHeaderCorruption.logHeader(secondBlock);
            c.write(HFileBlock.Header.ON_DISK_SIZE_WITHOUT_HEADER_INDEX, ByteBuffer.wrap(Bytes.toBytes((int)Integer.MIN_VALUE)));
            TestHFileBlockHeaderCorruption.logHeader(secondBlock);
            try (HFileBlockChannelPositionIterator it = new HFileBlockChannelPositionIterator(this.hFileTestRule);){
                consumer = new CountingConsumer(it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(IOException.class).withMessage((Matcher<String>)Matchers.startsWith((String)"Invalid onDiskSizeWithHeader=")));
                }
                Assert.assertEquals((long)1L, (long)consumer.getItemsRead());
            }
            c.restore();
            c.write(HFileBlock.Header.ON_DISK_SIZE_WITHOUT_HEADER_INDEX, ByteBuffer.wrap(Bytes.toBytes((int)0)));
            TestHFileBlockHeaderCorruption.logHeader(secondBlock);
            it = new HFileBlockChannelPositionIterator(this.hFileTestRule);
            var4_6 = null;
            try {
                consumer = new CountingConsumer(it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(IllegalArgumentException.class));
                }
                Assert.assertEquals((long)1L, (long)consumer.getItemsRead());
            }
            catch (Throwable consumer2) {
                var4_6 = consumer2;
                throw consumer2;
            }
            finally {
                if (it != null) {
                    if (var4_6 != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable consumer2) {
                            var4_6.addSuppressed(consumer2);
                        }
                    } else {
                        it.close();
                    }
                }
            }
            c.restore();
            c.write(HFileBlock.Header.ON_DISK_SIZE_WITHOUT_HEADER_INDEX, ByteBuffer.wrap(Bytes.toBytes((int)Integer.MAX_VALUE)));
            TestHFileBlockHeaderCorruption.logHeader(secondBlock);
            it = new HFileBlockChannelPositionIterator(this.hFileTestRule);
            var4_6 = null;
            try {
                consumer = new CountingConsumer(it);
                try {
                    consumer.readFully();
                    Assert.fail();
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)new IsThrowableMatching().withInstanceOf(IOException.class).withMessage((Matcher<String>)Matchers.startsWith((String)"Invalid onDiskSizeWithHeader=")));
                }
                Assert.assertEquals((long)1L, (long)consumer.getItemsRead());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (it != null) {
                    if (var4_6 != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        it.close();
                    }
                }
            }
        }
    }

    private static void logHeader(HFileBlockChannelPosition hbcp) throws IOException {
        ByteBuff buf = ByteBuff.wrap((ByteBuffer)ByteBuffer.allocate(HFileBlock.headerSize((boolean)true)));
        hbcp.rewind();
        Assert.assertEquals((long)buf.capacity(), (long)buf.read((ReadableByteChannel)hbcp.getChannel()));
        buf.rewind();
        hbcp.rewind();
        TestHFileBlockHeaderCorruption.logHeader(buf);
    }

    private static void logHeader(ByteBuff buf) {
        byte[] blockMagic = new byte[8];
        buf.get(blockMagic);
        int onDiskSizeWithoutHeader = buf.getInt();
        int uncompressedSizeWithoutHeader = buf.getInt();
        long prevBlockOffset = buf.getLong();
        byte checksumType = buf.get();
        int bytesPerChecksum = buf.getInt();
        int onDiskDataSizeWithHeader = buf.getInt();
        LOG.debug("blockMagic={}, onDiskSizeWithoutHeader={}, uncompressedSizeWithoutHeader={}, prevBlockOffset={}, checksumType={}, bytesPerChecksum={}, onDiskDataSizeWithHeader={}", new Object[]{Bytes.toStringBinary((byte[])blockMagic), onDiskSizeWithoutHeader, uncompressedSizeWithoutHeader, prevBlockOffset, checksumType, bytesPerChecksum, onDiskDataSizeWithHeader});
    }

    private static final class IsThrowableMatching
    extends TypeSafeMatcher<Throwable> {
        private final List<Matcher<? super Throwable>> requirements = new LinkedList<Matcher<? super Throwable>>();

        private IsThrowableMatching() {
        }

        public IsThrowableMatching withInstanceOf(Class<?> type) {
            this.requirements.add((Matcher<? super Throwable>)Matchers.instanceOf(type));
            return this;
        }

        public IsThrowableMatching withMessage(Matcher<String> matcher) {
            this.requirements.add((Matcher<? super Throwable>)Matchers.hasProperty((String)"message", matcher));
            return this;
        }

        protected boolean matchesSafely(Throwable throwable) {
            return Matchers.allOf(this.requirements).matches((Object)throwable);
        }

        protected void describeMismatchSafely(Throwable item, Description mismatchDescription) {
            Matchers.allOf(this.requirements).describeMismatch((Object)item, mismatchDescription);
            mismatchDescription.appendText(String.format("%nProvided: ", new Object[0]));
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                try (PrintStream ps = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8.name());){
                    item.printStackTrace(ps);
                    ps.flush();
                }
                mismatchDescription.appendText(baos.toString(StandardCharsets.UTF_8.name()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void describeTo(Description description) {
            description.appendDescriptionOf((SelfDescribing)Matchers.allOf(this.requirements));
        }
    }

    public static class HFileTestRule
    extends ExternalResource {
        private final HBaseTestingUtility testingUtility;
        private final HFileSystem hfs;
        private final HFileContext context;
        private final TestName testName;
        private Path path;

        public HFileTestRule(HBaseTestingUtility testingUtility, TestName testName) throws IOException {
            this.testingUtility = testingUtility;
            this.testName = testName;
            this.hfs = (HFileSystem)HFileSystem.get((Configuration)testingUtility.getConfiguration());
            this.context = new HFileContextBuilder().withBlockSize(4096).withHBaseCheckSum(true).build();
        }

        public Configuration getConfiguration() {
            return this.testingUtility.getConfiguration();
        }

        public HFileSystem getHFileSystem() {
            return this.hfs;
        }

        public HFileContext getHFileContext() {
            return this.context;
        }

        public Path getPath() {
            return this.path;
        }

        public SeekableByteChannel getRWChannel() throws IOException {
            java.nio.file.Path p = FileSystems.getDefault().getPath(this.path.toString(), new String[0]);
            return Files.newByteChannel(p, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC);
        }

        protected void before() throws Throwable {
            this.path = new Path(this.testingUtility.getDataTestDirOnTestFS(), this.testName.getMethodName());
            HFile.WriterFactory factory = HFile.getWriterFactory((Configuration)this.testingUtility.getConfiguration(), (CacheConfig)CacheConfig.DISABLED).withPath((FileSystem)this.hfs, this.path).withFileContext(this.context);
            CellBuilder cellBuilder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY);
            Random rand = new Random(Instant.now().toEpochMilli());
            byte[] family = Bytes.toBytes((String)"f");
            try (HFile.Writer writer = factory.create();){
                for (int i = 0; i < 40; ++i) {
                    byte[] row = RandomKeyValueUtil.randomOrderedFixedLengthKey(rand, i, 100);
                    byte[] qualifier = RandomKeyValueUtil.randomRowOrQualifier(rand);
                    byte[] value = RandomKeyValueUtil.randomValue(rand);
                    Cell cell = cellBuilder.setType(Cell.Type.Put).setRow(row).setFamily(family).setQualifier(qualifier).setValue(value).build();
                    writer.append(cell);
                    cellBuilder.clear();
                }
            }
        }
    }

    public static class Corrupter {
        private final HFileBlockChannelPosition channelAndPosition;
        private final ByteBuffer originalHeader;

        public Corrupter(HFileBlockChannelPosition channelAndPosition) throws IOException {
            this.channelAndPosition = channelAndPosition;
            this.originalHeader = Corrupter.readHeaderData(channelAndPosition);
        }

        private static ByteBuffer readHeaderData(HFileBlockChannelPosition channelAndPosition) throws IOException {
            SeekableByteChannel channel = channelAndPosition.getChannel();
            ByteBuffer originalHeader = ByteBuffer.allocate(HFileBlock.headerSize((boolean)true));
            channelAndPosition.rewind();
            channel.read(originalHeader);
            return originalHeader;
        }

        public void write(int offset, ByteBuffer src) throws IOException {
            SeekableByteChannel channel = this.channelAndPosition.getChannel();
            long position = this.channelAndPosition.getPosition();
            channel.position(position + (long)offset);
            channel.write(src);
        }

        public void restore() throws IOException {
            SeekableByteChannel channel = this.channelAndPosition.getChannel();
            this.originalHeader.rewind();
            this.channelAndPosition.rewind();
            Assert.assertEquals((long)this.originalHeader.capacity(), (long)channel.write(this.originalHeader));
        }
    }

    public static class HFileBlockChannelPositionIterator
    implements Closeable {
        private final HFileTestRule hFileTestRule;
        private final HFile.Reader reader;
        private final HFileBlock.BlockIterator iter;
        private HFileBlockChannelPosition current = null;

        public HFileBlockChannelPositionIterator(HFileTestRule hFileTestRule) throws IOException {
            Configuration conf = hFileTestRule.getConfiguration();
            HFileSystem hfs = hFileTestRule.getHFileSystem();
            Path hfsPath = hFileTestRule.getPath();
            HFile.Reader reader = null;
            HFileBlock.BlockIterator iter = null;
            try {
                reader = HFile.createReader((FileSystem)hfs, (Path)hfsPath, (CacheConfig)CacheConfig.DISABLED, (boolean)true, (Configuration)conf);
                HFileBlock.FSReader fsreader = reader.getUncachedBlockReader();
                iter = fsreader.blockRange(0L, reader.getTrailer().getLoadOnOpenDataOffset());
            }
            catch (IOException e) {
                if (reader != null) {
                    HFileBlockChannelPositionIterator.closeQuietly(() -> reader.close());
                }
                throw e;
            }
            this.hFileTestRule = hFileTestRule;
            this.reader = reader;
            this.iter = iter;
        }

        public boolean hasNext() throws IOException {
            HFileBlock next = this.iter.nextBlock();
            SeekableByteChannel channel = this.hFileTestRule.getRWChannel();
            if (next != null) {
                this.current = new HFileBlockChannelPosition(channel, next.getOffset());
            }
            return next != null;
        }

        public HFileBlockChannelPosition next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            HFileBlockChannelPosition ret = this.current;
            this.current = null;
            return ret;
        }

        @Override
        public void close() throws IOException {
            if (this.current != null) {
                HFileBlockChannelPositionIterator.closeQuietly(this.current::close);
            }
            HFileBlockChannelPositionIterator.closeQuietly(() -> this.reader.close());
        }

        private static void closeQuietly(CloseMethod closeMethod) {
            try {
                closeMethod.run();
            }
            catch (Throwable e) {
                LOG.debug("Ignoring thrown exception.", e);
            }
        }

        @FunctionalInterface
        private static interface CloseMethod {
            public void run() throws IOException;
        }
    }

    public static class CountingConsumer {
        private final HFileBlockChannelPositionIterator iterator;
        private int itemsRead = 0;

        public CountingConsumer(HFileBlockChannelPositionIterator iterator) {
            this.iterator = iterator;
        }

        public int getItemsRead() {
            return this.itemsRead;
        }

        public Object readFully() throws IOException {
            HFileBlockChannelPosition val = null;
            this.itemsRead = 0;
            while (this.iterator.hasNext()) {
                val = this.iterator.next();
                ++this.itemsRead;
            }
            return val;
        }
    }

    public static class HFileBlockChannelPosition
    implements Closeable {
        private final SeekableByteChannel channel;
        private final long position;

        public HFileBlockChannelPosition(SeekableByteChannel channel, long position) {
            this.channel = channel;
            this.position = position;
        }

        public SeekableByteChannel getChannel() {
            return this.channel;
        }

        public long getPosition() {
            return this.position;
        }

        public void rewind() throws IOException {
            this.channel.position(this.position);
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

