/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTableResultScanner;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TestAsyncTableScanMetrics;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsRegionInfo;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableScanMetricsWithScannerSuspending {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableScanMetricsWithScannerSuspending.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)TestAsyncTableScanMetricsWithScannerSuspending.class.getSimpleName());
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static AsyncConnection CONN;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        try (Table table = UTIL.createMultiRegionTable(TABLE_NAME, CF);){
            table.put(Arrays.asList(new Put(Bytes.toBytes((String)"xxx1")).addColumn(CF, CQ, VALUE), new Put(Bytes.toBytes((String)"yyy1")).addColumn(CF, CQ, VALUE), new Put(Bytes.toBytes((String)"zzz1")).addColumn(CF, CQ, VALUE)));
        }
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testScanMetricsByRegionWithScannerSuspending() throws Exception {
        Scan scan = new Scan();
        scan.withStartRow(Bytes.toBytes((String)"xxx1"), true);
        scan.withStopRow(Bytes.toBytes((String)"zzz1"), true);
        scan.setEnableScanMetricsByRegion(true);
        scan.setMaxResultSize(1L);
        final AtomicInteger rowsReadCounter = new AtomicInteger(0);
        final AsyncTableResultScanner scanner = new AsyncTableResultScanner(TABLE_NAME, scan, 1L){

            public void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
                rowsReadCounter.addAndGet(results.length);
                super.onNext(results, controller);
            }
        };
        CONN.getTable(TABLE_NAME).scan(scan, (ScanResultConsumerBase)scanner);
        ArrayList<Result> results = new ArrayList<Result>();
        int expectedTotalRows = 3;
        for (int i = 1; i <= expectedTotalRows; ++i) {
            UTIL.waitFor(10000L, 100L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return scanner.isSuspended();
                }

                public String explainFailure() throws Exception {
                    return "The given scanner has been suspended in time";
                }
            });
            Assert.assertTrue((boolean)scanner.isSuspended());
            Assert.assertEquals((long)i, (long)rowsReadCounter.get());
            results.add(scanner.next());
        }
        Assert.assertNull((Object)scanner.next());
        ScanMetrics scanMetrics = scanner.getScanMetrics();
        long bytes = TestAsyncTableScanMetrics.getBytesOfResults(results);
        Map overallMetrics = scanMetrics.getMetricsMap(false);
        Assert.assertEquals((long)3L, (long)((Long)overallMetrics.get("REGIONS_SCANNED")));
        Assert.assertEquals((long)bytes, (long)((Long)overallMetrics.get("BYTES_IN_RESULTS")));
        Assert.assertEquals((long)6L, (long)((Long)overallMetrics.get("RPC_CALLS")));
        Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion(false);
        Assert.assertEquals((long)3L, (long)scanMetricsByRegion.size());
        for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
            ScanMetricsRegionInfo smri = (ScanMetricsRegionInfo)entry.getKey();
            Map perRegionMetrics = (Map)entry.getValue();
            Assert.assertNotNull((Object)smri.getServerName());
            Assert.assertNotNull((Object)smri.getEncodedRegionName());
            Assert.assertEquals((long)1L, (long)((Long)perRegionMetrics.get("REGIONS_SCANNED")));
            Assert.assertEquals((long)1L, (long)((Long)perRegionMetrics.get("ROWS_SCANNED")));
            bytes = TestAsyncTableScanMetrics.getBytesOfResults(Collections.singletonList(results.get(0)));
            Assert.assertEquals((long)bytes, (long)((Long)perRegionMetrics.get("BYTES_IN_RESULTS")));
            Assert.assertEquals((long)2L, (long)((Long)perRegionMetrics.get("RPC_CALLS")));
        }
    }
}

