/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.crypto.DefaultCipherProvider;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyStoreKeyProvider;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class EncryptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionTest.class);
    static final Map<String, Boolean> keyProviderResults = new ConcurrentHashMap<String, Boolean>();
    static final Map<String, Boolean> cipherProviderResults = new ConcurrentHashMap<String, Boolean>();
    static final Map<String, Boolean> cipherResults = new ConcurrentHashMap<String, Boolean>();

    private EncryptionTest() {
    }

    public static void testKeyProvider(Configuration conf) throws IOException {
        String providerClassName = conf.get("hbase.crypto.keyprovider", KeyStoreKeyProvider.class.getName());
        Boolean result = keyProviderResults.get(providerClassName);
        if (result == null) {
            try {
                Encryption.getKeyProvider(conf);
                keyProviderResults.put(providerClassName, true);
            }
            catch (Exception e) {
                keyProviderResults.put(providerClassName, false);
                throw new IOException("Key provider " + providerClassName + " failed test: " + e.getMessage(), e);
            }
        } else if (!result.booleanValue()) {
            throw new IOException("Key provider " + providerClassName + " previously failed test");
        }
    }

    public static void testCipherProvider(Configuration conf) throws IOException {
        String providerClassName = conf.get("hbase.crypto.cipherprovider", DefaultCipherProvider.class.getName());
        Boolean result = cipherProviderResults.get(providerClassName);
        if (result == null) {
            try {
                Encryption.getCipherProvider(conf);
                cipherProviderResults.put(providerClassName, true);
            }
            catch (Exception e) {
                cipherProviderResults.put(providerClassName, false);
                throw new IOException("Cipher provider " + providerClassName + " failed test: " + e.getMessage(), e);
            }
        } else if (!result.booleanValue()) {
            throw new IOException("Cipher provider " + providerClassName + " previously failed test");
        }
    }

    public static void testEncryption(Configuration conf, String cipher, byte[] key) throws IOException {
        if (cipher == null) {
            return;
        }
        if (!Encryption.isEncryptionEnabled(conf)) {
            String message = String.format("Cipher %s failed test: encryption is disabled on the cluster", cipher);
            throw new IOException(message);
        }
        EncryptionTest.testKeyProvider(conf);
        EncryptionTest.testCipherProvider(conf);
        Boolean result = cipherResults.get(cipher);
        if (result == null) {
            try {
                Encryption.Context context = Encryption.newContext(conf);
                context.setCipher(Encryption.getCipher(conf, cipher));
                if (key == null) {
                    context.setKey(context.getCipher().getRandomKey());
                } else {
                    context.setKey(EncryptionUtil.unwrapKey(conf, conf.get("hbase.crypto.master.key.name", "hbase"), key));
                }
                byte[] iv = null;
                if (context.getCipher().getIvLength() > 0) {
                    iv = new byte[context.getCipher().getIvLength()];
                    Bytes.secureRandom(iv);
                }
                byte[] plaintext = new byte[1024];
                Bytes.random(plaintext);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Encryption.encrypt(out, new ByteArrayInputStream(plaintext), context, iv);
                byte[] ciphertext = out.toByteArray();
                out.reset();
                Encryption.decrypt(out, new ByteArrayInputStream(ciphertext), plaintext.length, context, iv);
                byte[] test = out.toByteArray();
                if (!Bytes.equals(plaintext, test)) {
                    throw new IOException("Did not pass encrypt/decrypt test");
                }
                cipherResults.put(cipher, true);
            }
            catch (Exception e) {
                cipherResults.put(cipher, false);
                throw new IOException("Cipher " + cipher + " failed test: " + e.getMessage(), e);
            }
        } else if (!result.booleanValue()) {
            throw new IOException("Cipher " + cipher + " previously failed test");
        }
    }
}

