/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.IOUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class WALDecompressionBoundedDelegatingInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(WALDecompressionBoundedDelegatingInputStream.class);
    private InputStream in;
    private long pos;
    private long limit;

    WALDecompressionBoundedDelegatingInputStream() {
    }

    public void reset(InputStream in, long limit) {
        this.in = in;
        this.limit = limit;
        this.pos = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        int result = this.in.read();
        if (result < 0) {
            return -1;
        }
        ++this.pos;
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        int toRead = (int)Math.min((long)len, this.limit - this.pos);
        int readBytes = IOUtils.read(this.in, b, off, toRead);
        this.pos += (long)readBytes;
        if (readBytes != toRead) {
            LOG.debug("Got EOF while we want to read {} bytes from stream, but only read {}", (Object)toRead, (Object)readBytes);
            return -1;
        }
        return toRead;
    }

    @Override
    public long skip(long len) throws IOException {
        long skipped = this.in.skip(Math.min(len, this.limit - this.pos));
        this.pos += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (this.pos >= this.limit) {
            return 0;
        }
        return (int)(this.limit - this.pos);
    }
}

