/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.procedure2.BaseRSProcedureCallable;
import org.apache.hadoop.hbase.replication.regionserver.PeerProcedureHandler;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClaimReplicationQueueCallable
extends BaseRSProcedureCallable {
    private ServerName crashedServer;
    private String queue;

    @Override
    public EventType getEventType() {
        return EventType.RS_CLAIM_REPLICATION_QUEUE;
    }

    @Override
    protected void doCall() throws Exception {
        PeerProcedureHandler handler = this.rs.getReplicationSourceService().getPeerProcedureHandler();
        handler.claimReplicationQueue(this.crashedServer, this.queue);
    }

    @Override
    protected void initParameter(byte[] parameter) throws InvalidProtocolBufferException {
        MasterProcedureProtos.ClaimReplicationQueueRemoteParameter param = MasterProcedureProtos.ClaimReplicationQueueRemoteParameter.parseFrom((byte[])parameter);
        this.crashedServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)param.getCrashedServer());
        this.queue = param.getQueue();
    }
}

