/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.thrift.TBoundedThreadPoolServer;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hbase.thirdparty.org.apache.commons.cli.OptionGroup;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public enum ImplType {
    HS_HA("hsha", true, THsHaServer.class, true),
    NONBLOCKING("nonblocking", true, TNonblockingServer.class, true),
    THREAD_POOL("threadpool", false, TBoundedThreadPoolServer.class, true),
    THREADED_SELECTOR("threadedselector", true, TThreadedSelectorServer.class, true);

    private static final Logger LOG;
    public static final ImplType DEFAULT;
    final String option;
    final boolean isAlwaysFramed;
    final Class<? extends TServer> serverClass;
    final boolean canSpecifyBindIP;

    private ImplType(String option, boolean isAlwaysFramed, Class<? extends TServer> serverClass, boolean canSpecifyBindIP) {
        this.option = option;
        this.isAlwaysFramed = isAlwaysFramed;
        this.serverClass = serverClass;
        this.canSpecifyBindIP = canSpecifyBindIP;
    }

    public String toString() {
        return "-" + this.option;
    }

    public String getOption() {
        return this.option;
    }

    public boolean isAlwaysFramed() {
        return this.isAlwaysFramed;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder("Use the " + this.serverClass.getSimpleName());
        if (this.isAlwaysFramed) {
            sb.append(" This implies the framed transport.");
        }
        if (this == DEFAULT) {
            sb.append("This is the default.");
        }
        return sb.toString();
    }

    static OptionGroup createOptionGroup() {
        OptionGroup group = new OptionGroup();
        for (ImplType t : ImplType.values()) {
            group.addOption(new Option(t.option, t.getDescription()));
        }
        return group;
    }

    public static ImplType getServerImpl(Configuration conf) {
        String confType = conf.get("hbase.regionserver.thrift.server.type", ImplType.THREAD_POOL.option);
        for (ImplType t : ImplType.values()) {
            if (!confType.equals(t.option)) continue;
            return t;
        }
        throw new AssertionError((Object)("Unknown server ImplType.option:" + confType));
    }

    static void setServerImpl(CommandLine cmd, Configuration conf) {
        ImplType chosenType = null;
        int numChosen = 0;
        for (ImplType t : ImplType.values()) {
            if (!cmd.hasOption(t.option)) continue;
            chosenType = t;
            ++numChosen;
        }
        if (numChosen < 1) {
            LOG.info("Using default thrift server type");
            chosenType = DEFAULT;
        } else if (numChosen > 1) {
            throw new AssertionError((Object)("Exactly one option out of " + Arrays.toString((Object[])ImplType.values()) + " has to be specified"));
        }
        LOG.info("Using thrift server type " + chosenType.option);
        conf.set("hbase.regionserver.thrift.server.type", chosenType.option);
    }

    public String simpleClassName() {
        return this.serverClass.getSimpleName();
    }

    public static List<String> serversThatCannotSpecifyBindIP() {
        ArrayList<String> l = new ArrayList<String>();
        for (ImplType t : ImplType.values()) {
            if (t.canSpecifyBindIP) continue;
            l.add(t.simpleClassName());
        }
        return l;
    }

    static {
        LOG = LoggerFactory.getLogger(ImplType.class);
        DEFAULT = THREAD_POOL;
    }
}

