/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.hibernate.management.impl.BaseEmitterBean;
import net.sf.ehcache.management.sampled.SampledCacheMBean;
import net.sf.ehcache.util.CacheTransactionHelper;
import net.sf.ehcache.writer.writebehind.WriteBehindManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampledCache
extends BaseEmitterBean
implements SampledCacheMBean,
CacheConfigurationListener,
PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)SampledCache.class.getName());
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final Ehcache cache;
    private final String immutableCacheName;

    public SampledCache(Ehcache cache) throws NotCompliantMBeanException {
        super(SampledCacheMBean.class);
        this.cache = cache;
        this.immutableCacheName = cache.getName();
        cache.getCacheConfiguration().addConfigurationListener(this);
        cache.addPropertyChangeListener(this);
    }

    String getImmutableCacheName() {
        return this.immutableCacheName;
    }

    @Override
    public boolean isEnabled() {
        return !this.cache.isDisabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        try {
            this.cache.setDisabled(!enabled);
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    @Deprecated
    public boolean isClusterCoherent() {
        try {
            return this.cache.isClusterCoherent();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public boolean isClusterBulkLoadEnabled() {
        try {
            return this.cache.isClusterBulkLoadEnabled();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    @Deprecated
    public boolean isNodeCoherent() {
        try {
            return this.cache.isNodeCoherent();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public boolean isNodeBulkLoadEnabled() {
        return !this.isNodeCoherent();
    }

    @Override
    @Deprecated
    public void setNodeCoherent(boolean coherent) {
        boolean isNodeCoherent = this.isNodeCoherent();
        if (coherent != isNodeCoherent) {
            if (!coherent && this.getTransactional()) {
                LOG.warn("a transactional cache cannot be incoherent");
                return;
            }
            try {
                this.cache.setNodeCoherent(coherent);
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public void setNodeBulkLoadEnabled(boolean bulkLoadEnabled) {
        if (bulkLoadEnabled && this.getTransactional()) {
            LOG.warn("a transactional cache cannot be put into bulk-load mode");
            return;
        }
        this.setNodeCoherent(!bulkLoadEnabled);
    }

    private RuntimeException newPlainException(RuntimeException e) {
        String type = e.getClass().getName();
        if (type.startsWith("java.") || type.startsWith("javax.")) {
            return e;
        }
        RuntimeException result = new RuntimeException(e.getMessage());
        result.setStackTrace(e.getStackTrace());
        return result;
    }

    @Override
    public void flush() {
        try {
            this.cache.flush();
            this.sendNotification("CacheFlushed", this.getCacheAttributes(), this.getImmutableCacheName());
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public String getCacheName() {
        return this.cache.getName();
    }

    @Override
    public String getStatus() {
        return this.cache.getStatus().toString();
    }

    @Override
    public void removeAll() {
        CacheTransactionHelper.beginTransactionIfNeeded(this.cache);
        try {
            this.cache.removeAll();
            this.sendNotification("CacheCleared", this.getCacheAttributes(), this.getImmutableCacheName());
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
        finally {
            try {
                CacheTransactionHelper.commitTransactionIfNeeded(this.cache);
            }
            catch (RuntimeException e2) {
                throw this.newPlainException(e2);
            }
        }
    }

    @Override
    public long getAverageGetTimeMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getAverageGetTimeMostRecentSample();
    }

    @Override
    public long getCacheElementEvictedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementEvictedMostRecentSample();
    }

    @Override
    public long getCacheElementExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementExpiredMostRecentSample();
    }

    @Override
    public long getCacheElementPutMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementPutMostRecentSample();
    }

    @Override
    public long getCacheElementRemovedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementRemovedMostRecentSample();
    }

    @Override
    public long getCacheElementUpdatedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementUpdatedMostRecentSample();
    }

    @Override
    public long getCacheHitInMemoryMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitInMemoryMostRecentSample();
    }

    @Override
    public long getCacheHitOffHeapMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitOffHeapMostRecentSample();
    }

    @Override
    public long getCacheHitMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitMostRecentSample();
    }

    @Override
    public long getCacheHitOnDiskMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissExpiredMostRecentSample();
    }

    @Override
    public long getCacheMissMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissMostRecentSample();
    }

    @Override
    public long getCacheMissInMemoryMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissInMemoryMostRecentSample();
    }

    @Override
    public long getCacheMissOffHeapMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissOffHeapMostRecentSample();
    }

    @Override
    public long getCacheMissOnDiskMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissNotFoundMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissNotFoundMostRecentSample();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracy();
    }

    @Override
    public String getStatisticsAccuracyDescription() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracyDescription();
    }

    @Override
    public void clearStatistics() {
        try {
            this.cache.clearStatistics();
            this.sendNotification("CacheStatisticsReset", this.getCacheAttributes(), this.getImmutableCacheName());
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.cache.isStatisticsEnabled();
    }

    @Override
    public boolean isSampledStatisticsEnabled() {
        return this.cache.getSampledCacheStatistics().isSampledStatisticsEnabled();
    }

    @Override
    public boolean isTerracottaClustered() {
        return this.cache.getCacheConfiguration().isTerracottaClustered();
    }

    @Override
    public String getTerracottaConsistency() {
        TerracottaConfiguration.Consistency consistency = this.cache.getCacheConfiguration().getTerracottaConsistency();
        return consistency != null ? consistency.name() : "na";
    }

    @Override
    public String getTerracottaStorageStrategy() {
        TerracottaConfiguration.StorageStrategy storageStrategy = this.cache.getCacheConfiguration().getTerracottaStorageStrategy();
        return storageStrategy != null ? storageStrategy.name() : "na";
    }

    @Override
    public void enableStatistics() {
        if (!this.cache.isStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(true);
                this.cache.setStatisticsEnabled(true);
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public void disableStatistics() {
        if (this.cache.isStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(false);
                this.cache.setStatisticsEnabled(false);
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public void setStatisticsEnabled(boolean statsEnabled) {
        boolean oldValue = this.isStatisticsEnabled();
        if (oldValue != statsEnabled) {
            if (statsEnabled) {
                this.enableStatistics();
            } else {
                this.disableStatistics();
            }
        }
    }

    @Override
    public void enableSampledStatistics() {
        if (!this.cache.isSampledStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(true);
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public void disableSampledStatistics() {
        if (this.cache.isSampledStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(false);
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public float getAverageGetTimeMillis() {
        try {
            return this.cache.getLiveCacheStatistics().getAverageGetTimeMillis();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getMaxGetTimeMillis() {
        try {
            return this.cache.getLiveCacheStatistics().getMaxGetTimeMillis();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getXaCommitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getXaCommitCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getXaRollbackCount() {
        try {
            return this.cache.getLiveCacheStatistics().getXaRollbackCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public boolean getHasWriteBehindWriter() {
        return this.cache.getWriterManager() instanceof WriteBehindManager && this.cache.getRegisteredCacheWriter() != null;
    }

    @Override
    public long getWriterQueueLength() {
        try {
            return this.cache.getLiveCacheStatistics().getWriterQueueLength();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public int getWriterMaxQueueSize() {
        return this.cache.getCacheConfiguration().getCacheWriterConfiguration().getWriteBehindMaxQueueSize();
    }

    @Override
    public int getWriterConcurrency() {
        return this.cache.getCacheConfiguration().getCacheWriterConfiguration().getWriteBehindConcurrency();
    }

    @Override
    public long getMinGetTimeMillis() {
        try {
            return this.cache.getLiveCacheStatistics().getMinGetTimeMillis();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getCacheHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getCacheHitCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getCacheMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getCacheMissCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getInMemoryMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getInMemoryMissCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getOffHeapMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOffHeapMissCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getOnDiskMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOnDiskMissCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getCacheMissCountExpired() {
        try {
            return this.cache.getLiveCacheStatistics().getCacheMissCountExpired();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getConfigDiskExpiryThreadIntervalSeconds() {
        return this.cache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds();
    }

    @Override
    public void setConfigDiskExpiryThreadIntervalSeconds(long seconds) {
        if (this.getConfigDiskExpiryThreadIntervalSeconds() != seconds) {
            try {
                this.cache.getCacheConfiguration().setDiskExpiryThreadIntervalSeconds(seconds);
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public int getConfigMaxElementsInMemory() {
        return this.cache.getCacheConfiguration().getMaxElementsInMemory();
    }

    @Override
    public void setConfigMaxElementsInMemory(int maxElements) {
        if (this.getConfigMaxElementsInMemory() != maxElements) {
            try {
                this.cache.getCacheConfiguration().setMaxElementsInMemory(maxElements);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public int getConfigMaxElementsOnDisk() {
        return this.cache.getCacheConfiguration().getMaxElementsOnDisk();
    }

    @Override
    public void setConfigMaxElementsOnDisk(int maxElements) {
        if (this.getConfigMaxElementsOnDisk() != maxElements) {
            try {
                this.cache.getCacheConfiguration().setMaxElementsOnDisk(maxElements);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public String getConfigMemoryStoreEvictionPolicy() {
        return this.cache.getCacheConfiguration().getMemoryStoreEvictionPolicy().toString();
    }

    @Override
    public void setConfigMemoryStoreEvictionPolicy(String evictionPolicy) {
        if (this.getConfigMemoryStoreEvictionPolicy() != evictionPolicy) {
            try {
                this.cache.getCacheConfiguration().setMemoryStoreEvictionPolicy(evictionPolicy);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public long getConfigTimeToIdleSeconds() {
        return this.cache.getCacheConfiguration().getTimeToIdleSeconds();
    }

    @Override
    public void setConfigTimeToIdleSeconds(long tti) {
        if (this.getConfigTimeToIdleSeconds() != tti) {
            try {
                this.cache.getCacheConfiguration().setTimeToIdleSeconds(tti);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public long getConfigTimeToLiveSeconds() {
        return this.cache.getCacheConfiguration().getTimeToLiveSeconds();
    }

    @Override
    public void setConfigTimeToLiveSeconds(long ttl) {
        if (this.getConfigTimeToLiveSeconds() != ttl) {
            try {
                this.cache.getCacheConfiguration().setTimeToLiveSeconds(ttl);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public boolean isConfigDiskPersistent() {
        return this.cache.getCacheConfiguration().isDiskPersistent();
    }

    @Override
    public void setConfigDiskPersistent(boolean diskPersistent) {
        if (this.isConfigDiskPersistent() != diskPersistent) {
            try {
                this.cache.getCacheConfiguration().setDiskPersistent(diskPersistent);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public boolean isConfigEternal() {
        return this.cache.getCacheConfiguration().isEternal();
    }

    @Override
    public void setConfigEternal(boolean eternal) {
        if (this.isConfigEternal() != eternal) {
            try {
                this.cache.getCacheConfiguration().setEternal(eternal);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public boolean isConfigOverflowToDisk() {
        return this.cache.getCacheConfiguration().isOverflowToDisk();
    }

    @Override
    public void setConfigOverflowToDisk(boolean overflowToDisk) {
        if (this.isConfigOverflowToDisk() != overflowToDisk) {
            try {
                this.cache.getCacheConfiguration().setOverflowToDisk(overflowToDisk);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public boolean isConfigLoggingEnabled() {
        return this.cache.getCacheConfiguration().getLogging();
    }

    @Override
    public void setConfigLoggingEnabled(boolean enabled) {
        if (this.isConfigLoggingEnabled() != enabled) {
            try {
                this.cache.getCacheConfiguration().setLogging(enabled);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw this.newPlainException(e);
            }
        }
    }

    @Override
    public long getEvictedCount() {
        try {
            return this.cache.getLiveCacheStatistics().getEvictedCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getExpiredCount() {
        try {
            return this.cache.getLiveCacheStatistics().getExpiredCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getInMemoryHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getInMemoryHitCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getInMemorySize() {
        try {
            return this.cache.getLiveCacheStatistics().getInMemorySize();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getOffHeapHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOffHeapHitCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getOffHeapSize() {
        try {
            return this.cache.getLiveCacheStatistics().getOffHeapSize();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getOnDiskHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOnDiskHitCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getOnDiskSize() {
        try {
            return this.cache.getLiveCacheStatistics().getOnDiskSize();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getPutCount() {
        try {
            return this.cache.getLiveCacheStatistics().getPutCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getRemovedCount() {
        try {
            return this.cache.getLiveCacheStatistics().getRemovedCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getSize() {
        try {
            return this.cache.getLiveCacheStatistics().getSize();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    @Override
    public long getUpdateCount() {
        try {
            return this.cache.getLiveCacheStatistics().getUpdateCount();
        }
        catch (RuntimeException e) {
            throw this.newPlainException(e);
        }
    }

    public Map<String, Object> getCacheAttributes() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Enabled", this.isEnabled());
        result.put("TerracottaClustered", this.isTerracottaClustered());
        result.put("LoggingEnabled", this.isConfigLoggingEnabled());
        result.put("TimeToIdleSeconds", this.getConfigTimeToIdleSeconds());
        result.put("TimeToLiveSeconds", this.getConfigTimeToLiveSeconds());
        result.put("MaxElementsInMemory", this.getConfigMaxElementsInMemory());
        result.put("MaxElementsOnDisk", this.getConfigMaxElementsOnDisk());
        result.put("DiskPersistent", this.isConfigDiskPersistent());
        result.put("Eternal", this.isConfigEternal());
        result.put("OverflowToDisk", this.isConfigOverflowToDisk());
        result.put("DiskExpiryThreadIntervalSeconds", this.getConfigDiskExpiryThreadIntervalSeconds());
        result.put("MemoryStoreEvictionPolicy", this.getConfigMemoryStoreEvictionPolicy());
        result.put("TerracottaConsistency", this.getTerracottaConsistency());
        result.put("NodeBulkLoadEnabled", this.isNodeBulkLoadEnabled());
        result.put("NodeCoherent", this.isNodeCoherent());
        result.put("ClusterBulkLoadEnabled", this.isClusterBulkLoadEnabled());
        result.put("ClusterCoherent", this.isClusterCoherent());
        result.put("StatisticsEnabled", this.isStatisticsEnabled());
        result.put("WriterConcurrency", this.getWriterConcurrency());
        result.put("Transactional", this.getTransactional());
        return result;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    @Override
    public void deregistered(CacheConfiguration config) {
    }

    @Override
    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
        if (oldCapacity != newCapacity) {
            this.setConfigMaxElementsOnDisk(newCapacity);
        }
    }

    @Override
    public void loggingChanged(boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.setConfigLoggingEnabled(newValue);
        }
    }

    @Override
    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        if (oldCapacity != newCapacity) {
            this.setConfigMaxElementsInMemory(newCapacity);
        }
    }

    @Override
    public void registered(CacheConfiguration config) {
    }

    @Override
    public void timeToIdleChanged(long oldTimeToIdle, long newTimeToIdle) {
        if (oldTimeToIdle != newTimeToIdle) {
            this.setConfigTimeToIdleSeconds(newTimeToIdle);
        }
    }

    @Override
    public void timeToLiveChanged(long oldTimeToLive, long newTimeToLive) {
        if (oldTimeToLive != newTimeToLive) {
            this.setConfigTimeToLiveSeconds(newTimeToLive);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    protected void doDispose() {
        this.cache.getCacheConfiguration().removeConfigurationListener(this);
    }

    @Override
    public long getAverageSearchTime() {
        return this.cache.getAverageSearchTime();
    }

    @Override
    public long getSearchesPerSecond() {
        return this.cache.getSearchesPerSecond();
    }

    @Override
    public boolean getTransactional() {
        return this.cache.getCacheConfiguration().getTransactionalMode().isTransactional();
    }

    @Override
    public boolean getSearchable() {
        return this.cache.getCacheConfiguration().getSearchable() != null;
    }

    @Override
    public long getCacheXaCommitsMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheXaCommitsMostRecentSample();
    }

    @Override
    public long getCacheXaRollbacksMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheXaRollbacksMostRecentSample();
    }

    static {
        String[] notifTypes = new String[]{"CacheEnabled", "CacheChanged", "CacheFlushed", "CacheStatisticsEnabled", "CacheStatisticsReset"};
        String name = Notification.class.getName();
        String description = "Ehcache SampledCache Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "Ehcache SampledCache Event")};
    }
}

