/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationSourceManagerJoin
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSourceManagerJoin.class);
    @Rule
    public TestName testName = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        NUM_SLAVES1 = 2;
        TestReplicationBase.setUpBeforeClass();
    }

    @Test
    public void testReplicationSourcesTerminate() throws Exception {
        TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
        hbaseAdmin.createTable(td);
        Assert.assertFalse((boolean)UTIL2.getAdmin().tableExists(tableName));
        Table table = UTIL1.getConnection().getTable(tableName);
        for (int i = 0; i < 100; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(famName, row, row));
        }
        Optional<HRegionServer> server = UTIL1.getMiniHBaseCluster().getLiveRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).filter(rs -> !rs.getRegions(tableName).isEmpty()).findAny();
        Assert.assertTrue((boolean)server.isPresent());
        server.get().abort("stopping for test");
        UTIL1.waitFor(60000L, () -> 1 == UTIL1.getMiniHBaseCluster().getNumLiveRegionServers());
        UTIL1.waitTableAvailable(tableName);
        HRegionServer rs2 = UTIL1.getMiniHBaseCluster().getLiveRegionServerThreads().get(0).getRegionServer();
        ReplicationSourceManager manager = rs2.getReplicationSourceService().getReplicationManager();
        UTIL1.waitFor(60000L, () -> !manager.getOldSources().isEmpty());
        Assert.assertFalse((boolean)manager.getSources().isEmpty());
        Assert.assertFalse((boolean)manager.getOldSources().isEmpty());
        Stream.concat(manager.getSources().stream(), manager.getOldSources().stream()).filter(src -> src instanceof ReplicationSource).forEach(src -> Assert.assertTrue((boolean)((ReplicationSource)src).sourceRunning));
        manager.join();
        Stream.concat(manager.getSources().stream(), manager.getOldSources().stream()).filter(src -> src instanceof ReplicationSource).forEach(src -> Assert.assertFalse((boolean)((ReplicationSource)src).sourceRunning));
    }
}

