/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestMobWithByteBuffAllocator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobWithByteBuffAllocator.class);
    private static final String TABLE_NAME = "TestMobWithByteBuffAllocator";
    private static final Logger LOG = LoggerFactory.getLogger(TestMobWithByteBuffAllocator.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Configuration CONF = UTIL.getConfiguration();
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");

    @BeforeClass
    public static void setUp() throws Exception {
        CONF.setBoolean("hbase.server.allocator.pool.enabled", true);
        CONF.setFloat("hfile.block.cache.size", 0.1f);
        CONF.set("hbase.bucketcache.ioengine", "offheap");
        CONF.setFloat("hbase.bucketcache.size", 32.0f);
        CONF.setInt("hbase.mob.file.cache.size", 0);
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testReadingCellsFromHFile() throws Exception {
        TableName tableName = TableName.valueOf((String)TABLE_NAME);
        MobSnapshotTestingUtils.createMobTable(UTIL, tableName, 1, (byte[][])new byte[][]{FAMILY});
        LOG.info("Create an mob table {} successfully.", (Object)tableName);
        int expectedRows = 500;
        SnapshotTestingUtils.loadData(UTIL, tableName, expectedRows, (byte[][])new byte[][]{FAMILY});
        LOG.info("Load 500 rows data into table {} successfully.", (Object)tableName);
        try (Admin admin = UTIL.getConnection().getAdmin();){
            admin.flush(tableName);
        }
        MobSnapshotTestingUtils.verifyMobRowCount(UTIL, tableName, expectedRows);
        int rows = 0;
        try (Table table = UTIL.getConnection().getTable(tableName);
             ResultScanner scanner = table.getScanner(new Scan().setReversed(true));){
            Result res = scanner.next();
            while (res != null) {
                ++rows;
                for (Cell cell : res.listCells()) {
                    Assert.assertTrue((CellUtil.cloneValue((Cell)cell).length > 0 ? 1 : 0) != 0);
                }
                res = scanner.next();
            }
        }
        Assert.assertEquals((long)expectedRows, (long)rows);
    }
}

