/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSetMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.SetMultimap;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestMobUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobUtils.class);
    public static final TableName TEST_TABLE_1 = TableName.valueOf((String)"testTable1");
    public static final TableName TEST_TABLE_2 = TableName.valueOf((String)"testTable2");
    public static final TableName TEST_TABLE_3 = TableName.valueOf((String)"testTable3");

    @Test
    public void serializeSingleMobFileRefs() {
        ImmutableSetMultimap mobRefSet = ImmutableSetMultimap.builder().putAll((Object)TEST_TABLE_1, (Object[])new String[]{"file1a"}).build();
        byte[] result = MobUtils.serializeMobFileRefs((SetMultimap)mobRefSet);
        Assert.assertEquals((Object)"testTable1/file1a", (Object)Bytes.toString((byte[])result));
    }

    @Test
    public void serializeMultipleMobFileRefs() {
        ImmutableSetMultimap mobRefSet = ImmutableSetMultimap.builder().putAll((Object)TEST_TABLE_1, (Object[])new String[]{"file1a", "file1b"}).putAll((Object)TEST_TABLE_2, (Object[])new String[]{"file2a"}).putAll((Object)TEST_TABLE_3, (Object[])new String[]{"file3a", "file3b"}).build();
        byte[] result = MobUtils.serializeMobFileRefs((SetMultimap)mobRefSet);
        Assert.assertEquals((Object)"testTable1/file1a,file1b//testTable2/file2a//testTable3/file3a,file3b", (Object)Bytes.toString((byte[])result));
    }

    @Test
    public void deserializeSingleMobFileRefs() {
        ImmutableSetMultimap mobRefSet = MobUtils.deserializeMobFileRefs((byte[])Bytes.toBytes((String)"testTable1/file1a")).build();
        Assert.assertEquals((long)1L, (long)mobRefSet.size());
        ImmutableSet testTable1Refs = mobRefSet.get((Object)TEST_TABLE_1);
        Assert.assertEquals((long)1L, (long)testTable1Refs.size());
        Assert.assertTrue((boolean)testTable1Refs.contains((Object)"file1a"));
    }

    @Test
    public void deserializeMultipleMobFileRefs() {
        ImmutableSetMultimap mobRefSet = MobUtils.deserializeMobFileRefs((byte[])Bytes.toBytes((String)"testTable1/file1a,file1b//testTable2/file2a//testTable3/file3a,file3b")).build();
        Assert.assertEquals((long)5L, (long)mobRefSet.size());
        ImmutableSet testTable1Refs = mobRefSet.get((Object)TEST_TABLE_1);
        ImmutableSet testTable2Refs = mobRefSet.get((Object)TEST_TABLE_2);
        ImmutableSet testTable3Refs = mobRefSet.get((Object)TEST_TABLE_3);
        Assert.assertEquals((long)2L, (long)testTable1Refs.size());
        Assert.assertEquals((long)1L, (long)testTable2Refs.size());
        Assert.assertEquals((long)2L, (long)testTable3Refs.size());
        Assert.assertTrue((boolean)testTable1Refs.contains((Object)"file1a"));
        Assert.assertTrue((boolean)testTable1Refs.contains((Object)"file1b"));
        Assert.assertTrue((boolean)testTable2Refs.contains((Object)"file2a"));
        Assert.assertTrue((boolean)testTable3Refs.contains((Object)"file3a"));
        Assert.assertTrue((boolean)testTable3Refs.contains((Object)"file3b"));
    }

    public static String getTableName(TestName test) {
        return test.getMethodName().replace("[", "-").replace("]", "");
    }
}

