/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.util.regex.Matcher;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={IOTests.class, SmallTests.class})
public class TestHFileLink {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileLink.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testValidLinkNames() {
        String[] validLinkNames;
        for (String name : validLinkNames = new String[]{"foo=fefefe-0123456", "ns=foo=abababa-fefefefe"}) {
            Assert.assertTrue((String)("Failed validating:" + name), (boolean)name.matches(HFileLink.LINK_NAME_REGEX));
        }
        for (String name : validLinkNames) {
            Assert.assertTrue((String)("Failed validating:" + name), (boolean)HFileLink.isHFileLink((String)name));
        }
        String testName = this.name.getMethodName() + "=fefefe-0123456";
        Assert.assertEquals((Object)TableName.valueOf((String)this.name.getMethodName()), (Object)HFileLink.getReferencedTableName((String)testName));
        Assert.assertEquals((Object)"fefefe", (Object)HFileLink.getReferencedRegionName((String)testName));
        Assert.assertEquals((Object)"0123456", (Object)HFileLink.getReferencedHFileName((String)testName));
        Assert.assertEquals((Object)testName, (Object)HFileLink.createHFileLinkName((TableName)TableName.valueOf((String)this.name.getMethodName()), (String)"fefefe", (String)"0123456"));
        testName = "ns=" + this.name.getMethodName() + "=fefefe-0123456";
        Assert.assertEquals((Object)TableName.valueOf((String)"ns", (String)this.name.getMethodName()), (Object)HFileLink.getReferencedTableName((String)testName));
        Assert.assertEquals((Object)"fefefe", (Object)HFileLink.getReferencedRegionName((String)testName));
        Assert.assertEquals((Object)"0123456", (Object)HFileLink.getReferencedHFileName((String)testName));
        Assert.assertEquals((Object)testName, (Object)HFileLink.createHFileLinkName((TableName)TableName.valueOf((String)"ns", (String)this.name.getMethodName()), (String)"fefefe", (String)"0123456"));
        for (String name : validLinkNames) {
            Matcher m = HFileLink.LINK_NAME_PATTERN.matcher(name);
            Assert.assertTrue((boolean)m.matches());
            Assert.assertEquals((Object)HFileLink.getReferencedTableName((String)name), (Object)TableName.valueOf((String)m.group(1), (String)m.group(2)));
            Assert.assertEquals((Object)HFileLink.getReferencedRegionName((String)name), (Object)m.group(3));
            Assert.assertEquals((Object)HFileLink.getReferencedHFileName((String)name), (Object)m.group(4));
        }
    }

    @Test
    public void testBackReference() {
        TableName[] refTables;
        Path rootDir = new Path("/root");
        Path archiveDir = new Path(rootDir, ".archive");
        String storeFileName = "121212";
        String linkDir = ".links-" + storeFileName;
        String encodedRegion = "FEFE";
        String cf = "cf1";
        for (TableName refTable : refTables = new TableName[]{TableName.valueOf((String)this.name.getMethodName()), TableName.valueOf((String)"ns", (String)this.name.getMethodName())}) {
            TableName[] tableNames;
            Path refTableDir = CommonFSUtils.getTableDir((Path)archiveDir, (TableName)refTable);
            Path refRegionDir = HRegion.getRegionDir((Path)refTableDir, (String)encodedRegion);
            Path refDir = new Path(refRegionDir, cf);
            Path refLinkDir = new Path(refDir, linkDir);
            String refStoreFileName = refTable.getNameAsString().replace(':', '=') + "=" + encodedRegion + "-" + storeFileName;
            for (TableName tableName : tableNames = new TableName[]{TableName.valueOf((String)(this.name.getMethodName() + "1")), TableName.valueOf((String)"ns", (String)(this.name.getMethodName() + "2")), TableName.valueOf((String)(this.name.getMethodName() + ":" + this.name.getMethodName()))}) {
                Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)tableName);
                Path regionDir = HRegion.getRegionDir((Path)tableDir, (String)encodedRegion);
                Path cfDir = new Path(regionDir, cf);
                Assert.assertEquals((Object)(encodedRegion + "." + tableName.getNameAsString().replace(':', '=')), (Object)HFileLink.createBackReferenceName((String)CommonFSUtils.getTableName((Path)tableDir).getNameAsString(), (String)encodedRegion));
                Pair parsedRef = HFileLink.parseBackReferenceName((String)(encodedRegion + "." + tableName.getNameAsString().replace(':', '=')));
                Assert.assertEquals((Object)parsedRef.getFirst(), (Object)tableName);
                Assert.assertEquals((Object)encodedRegion, (Object)parsedRef.getSecond());
                Path storeFileDir = new Path(refLinkDir, encodedRegion + "." + tableName.getNameAsString().replace(':', '='));
                Path linkPath = new Path(cfDir, refStoreFileName);
                Assert.assertEquals((Object)linkPath, (Object)HFileLink.getHFileFromBackReference((Path)rootDir, (Path)storeFileDir));
            }
        }
    }
}

