/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.MetaWithReplicasTestBase;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestCleanupMetaReplicaThroughConfig
extends MetaWithReplicasTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCleanupMetaReplicaThroughConfig.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestCleanupMetaReplicaThroughConfig.startCluster();
    }

    @Test
    public void testReplicaCleanup() throws Exception {
        ZKWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        List metaReplicaZnodes = zkw.getMetaReplicaNodes();
        Assert.assertEquals((long)3L, (long)metaReplicaZnodes.size());
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        master.stop("Restarting");
        TEST_UTIL.waitFor(30000L, () -> master.isStopped());
        TEST_UTIL.getMiniHBaseCluster().getConfiguration().setInt("hbase.meta.replica.count", 1);
        JVMClusterUtil.MasterThread newMasterThread = TEST_UTIL.getMiniHBaseCluster().startMaster();
        HMaster newMaster = newMasterThread.getMaster();
        TEST_UTIL.waitFor(30000L, () -> newMaster.getMasterQuotaManager() != null);
        TEST_UTIL.waitFor(30000L, () -> TEST_UTIL.getZooKeeperWatcher().getMetaReplicaNodes().size() == 1);
    }
}

